package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

public class SupportBotEntry implements Entity {
  @Nullable
  private SupportBot supportBot;
  @Nullable
  private Step step;
  @Nullable
  private List<ActionButton> buttons;

  @Nullable
  public List<ActionButton> getButtons() {
    return buttons;
  }

  @Override
  public String getId() {
    if (supportBot != null) {
      return supportBot.getId();
    }

    return null;
  }

  @Nullable
  public List<Block> getBlocks() {
    return Optional.ofNullable(step)
        .map(Step::getBlocks)
        .orElse(null);
  }

  @Nullable
  public String getPlainText() {
    return Optional.ofNullable(step)
        .map(Step::getPlainText)
        .orElse(null);
  }

  @Nullable
  public List<File> getFiles() {
    return Optional.ofNullable(step)
        .map(Step::getFiles)
        .orElse(null);
  }

  @Nullable
  public WebPage getWebPage() {
    return Optional.ofNullable(step)
        .map(Step::getWebPage)
        .orElse(null);
  }
}
