/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.language.LanguageSettingsActivity;
import com.zoyi.channel.plugin.android.activity.profile.EditProfileActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsPresenter;
import com.zoyi.channel.plugin.android.activity.settings.contract.SettingsContract;
import com.zoyi.channel.plugin.android.activity.settings.enumerate.OptionType;
import com.zoyi.channel.plugin.android.activity.settings.view.SettingsHeaderView;
import com.zoyi.channel.plugin.android.activity.settings.view.SettingsOptionInteractionListener;
import com.zoyi.channel.plugin.android.activity.settings.view.SettingsOptionView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import java.util.List;

public class SettingsActivity
extends BaseActivity2
implements SettingsContract.View,
CompoundButton.OnCheckedChangeListener,
SettingsOptionInteractionListener {
    private SettingsContract.Presenter presenter;
    private NavigationView navigation;
    private SettingsHeaderView header;
    private SettingsOptionView optionLanguage;
    private SwitchCompat switchTranslation;
    private SwitchCompat switchShowClosedChat;
    private SwitchCompat switchSoundVibrate;
    private View profileLayout;
    private TextView textSettingsProfile;
    private LinearLayout profileContents;
    private View profileLoader;
    private ErrorRefreshView profileErrorView;
    private TextView textVersion;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_settings);
        this.navigation = (NavigationView)this.findViewById(R.id.navigationSettings);
        this.header = (SettingsHeaderView)this.findViewById(R.id.headerSettings);
        this.optionLanguage = (SettingsOptionView)this.findViewById(R.id.optionLanguage);
        this.optionLanguage.setData(OptionType.LANGUAGE, ResUtils.getString(((CHLocale)((Object)SettingsStore.get().locale.get())).toString()));
        this.optionLanguage.setSettingsOptionInteractionListener(this);
        this.switchTranslation = (SwitchCompat)this.findViewById(R.id.switchTranslation);
        this.switchTranslation.setChecked(SettingsStore.get().showTranslation.get().booleanValue());
        this.switchTranslation.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.switchShowClosedChat = (SwitchCompat)this.findViewById(R.id.switchShowClosedChats);
        this.switchShowClosedChat.setChecked(SettingsStore.get().showClosedChat.get().booleanValue());
        this.switchShowClosedChat.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.switchSoundVibrate = (SwitchCompat)this.findViewById(R.id.switchSoundVibrate);
        this.switchSoundVibrate.setChecked(SettingsStore.get().raiseSoundVibrate.get().booleanValue());
        this.switchSoundVibrate.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.profileLayout = this.findViewById(R.id.layoutSettingsProfile);
        this.textSettingsProfile = (TextView)this.findViewById(R.id.textSettingsProfile);
        this.profileContents = (LinearLayout)this.findViewById(R.id.layoutSettingsProfileContent);
        this.profileLoader = this.findViewById(R.id.loaderSettingsProfile);
        this.profileErrorView = (ErrorRefreshView)this.findViewById(R.id.errorSettingsProfile);
        this.profileErrorView.setListener(v -> this.presenter.fetchProfileBotSchema());
        this.textVersion = (TextView)this.findViewById(R.id.textSettingsVersion);
        this.textVersion.setText((CharSequence)String.format("v%s", "7.0.2-beta2"));
        this.presenter = new SettingsPresenter(this);
        this.bindPresenter(this.presenter);
        return true;
    }

    protected void onPause() {
        super.onPause();
        if (this.isFinishing()) {
            Action.invoke(ActionType.SETTINGS_CLOSED);
        }
    }

    @Override
    public void onLocaleChange(CHLocale locale) {
        this.optionLanguage.setData(OptionType.LANGUAGE, ResUtils.getString(locale.toString()));
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView == null) {
            return;
        }
        int id2 = buttonView.getId();
        if (id2 == R.id.switchTranslation) {
            SettingsStore.get().showTranslation.set(isChecked);
            PrefSupervisor.setTranslateOption((Context)this, isChecked);
        } else if (id2 == R.id.switchShowClosedChats) {
            SettingsStore.get().showClosedChat.set(isChecked);
            PrefSupervisor.setShowClosedChat((Context)this, isChecked);
        } else if (id2 == R.id.switchSoundVibrate) {
            SettingsStore.get().raiseSoundVibrate.set(isChecked);
            PrefSupervisor.setPushAlarm((Context)this, isChecked);
        }
    }

    @Override
    public void onOptionClick(OptionType optionType, @Nullable String key, @Nullable String value) {
        switch (optionType) {
            case LANGUAGE: {
                IntentUtils.setNextActivity((Context)this, LanguageSettingsActivity.class).startActivity();
                break;
            }
            case PROFILE: {
                if (key == null) break;
                IntentUtils.setNextActivity((Context)this, EditProfileActivity.class).putExtra("EXTRA_PROFILE_KEY", key).putExtra("EXTRA_PROFILE_VALUE", value).startActivity();
            }
        }
    }

    @Override
    public void onProfileBotSchemasFetchStateChange(FetchState state) {
        this.profileLayout.setVisibility(8);
        this.profileLoader.setVisibility(8);
        this.profileErrorView.setVisibility(8);
        switch (state) {
            case COMPLETE: {
                this.profileLayout.setVisibility(0);
                break;
            }
            case LOADING: {
                this.profileLoader.setVisibility(0);
                break;
            }
            case FAILED: {
                this.profileErrorView.setVisibility(0);
            }
        }
    }

    @Override
    public void onProfileBotSchemasChange(List<ProfileBotSchema> profileBotSchemas, User user) {
        if (profileBotSchemas.size() > 0) {
            int i;
            this.textSettingsProfile.setVisibility(0);
            this.profileContents.setVisibility(0);
            for (i = 0; i < profileBotSchemas.size(); ++i) {
                if (this.profileContents.getChildCount() <= i) {
                    SettingsOptionView newOptionView = new SettingsOptionView((Context)this);
                    newOptionView.setSettingsOptionInteractionListener(this);
                    this.profileContents.addView((View)newOptionView);
                }
                ProfileBotSchema schema = profileBotSchemas.get(i);
                SettingsOptionView optionView = (SettingsOptionView)this.profileContents.getChildAt(i);
                if (schema != null && schema.getNameI18n() != null && schema.getNameI18n().get() != null) {
                    optionView.setData(schema, user);
                    optionView.setVisibility(0);
                    continue;
                }
                optionView.setVisibility(8);
            }
            for (i = profileBotSchemas.size(); i < this.profileContents.getChildCount(); ++i) {
                this.profileContents.getChildAt(i).setVisibility(8);
            }
        } else {
            this.textSettingsProfile.setVisibility(8);
            this.profileContents.setVisibility(8);
        }
    }
}

