/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.ActivityManager;
import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.EnumStateStatus;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import com.splunk.mint.StacktraceHash;
import com.splunk.mint.Utils;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ActionError
extends BaseDTO
implements InterfaceDataType {
    private String stacktrace;
    private Boolean handled;
    private String klass;
    private String message;
    private String errorHash;
    private String where;
    private byte gpsStatus;
    private String memSysTotal = null;
    private String memSysLow;
    private String memSysAvailable = null;
    private String memSysThreshold;
    private String memAppMax;
    private String memAppAvailable;
    private String memAppTotal;
    private JSONArray breadcrumbs;

    public ActionError(byte dataType, String stacktrace, byte exceptionType, HashMap<String, Object> customData) {
        super(dataType, customData);
        this.stacktrace = stacktrace;
        this.handled = exceptionType == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        HashMap<String, String> stackHashMap = StacktraceHash.manipulateStacktrace(Properties.APP_PACKAGE, stacktrace);
        this.klass = stackHashMap.get("klass");
        this.message = stackHashMap.get("message");
        this.errorHash = stackHashMap.get("errorHash");
        this.where = stackHashMap.get("where");
        this.gpsStatus = Properties.IS_GPS_ON;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Runtime rt = Runtime.getRuntime();
        if (!this.handled.booleanValue()) {
            HashMap<String, String> memInfo = Utils.getMemoryInfo();
            this.memSysTotal = memInfo.get("memTotal");
            this.memSysAvailable = memInfo.get("memFree");
        }
        DecimalFormat nft = new DecimalFormat("#.##");
        this.memSysThreshold = String.valueOf(nft.format((double)memoryInfo.threshold / 1048576.0));
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf(nft.format((double)rt.maxMemory() / 1048576.0));
        this.memAppAvailable = String.valueOf(nft.format((double)rt.freeMemory() / 1048576.0));
        this.memAppTotal = String.valueOf(nft.format((double)rt.totalMemory() / 1048576.0));
        this.breadcrumbs = Properties.breadcrumbs.getList();
    }

    public ActionError(byte dataType, String message, String file, String line, String stacktrace, HashMap<String, Object> map, byte exceptionType) {
        super(dataType, map);
        this.stacktrace = stacktrace;
        this.handled = exceptionType == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.klass = file;
        this.message = message;
        this.errorHash = StacktraceHash.getMD5ForJavascriptError(stacktrace);
        this.where = "line: " + line;
        this.gpsStatus = Properties.IS_GPS_ON;
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Runtime rt = Runtime.getRuntime();
        if (!this.handled.booleanValue()) {
            HashMap<String, String> memInfo = Utils.getMemoryInfo();
            this.memSysTotal = memInfo.get("memTotal");
            this.memSysAvailable = memInfo.get("memFree");
        }
        DecimalFormat nft = new DecimalFormat("#.##");
        this.memSysThreshold = String.valueOf(nft.format((double)memoryInfo.threshold / 1048576.0));
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf(nft.format((double)rt.maxMemory() / 1048576.0));
        this.memAppAvailable = String.valueOf(nft.format((double)rt.freeMemory() / 1048576.0));
        this.memAppTotal = String.valueOf(nft.format((double)rt.totalMemory() / 1048576.0));
        this.breadcrumbs = Properties.breadcrumbs.getList();
    }

    protected final String getErrorHash() {
        return this.errorHash;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            JSONObject stackArray = new JSONObject();
            stackArray.put("0", (Object)this.stacktrace);
            json.put("stacktrace", (Object)stackArray);
            json.put("threadCrashed", (Object)"0");
            json.put("handled", (Object)this.handled);
            json.put("klass", (Object)this.klass);
            json.put("message", (Object)this.message);
            json.put("errorHash", (Object)this.errorHash);
            json.put("where", (Object)this.where);
            json.put("rooted", Properties.HAS_ROOT);
            json.put("gpsStatus", (Object)EnumStateStatus.getStringFromStatus(this.gpsStatus));
            json.put("breadcrumbs", (Object)this.breadcrumbs);
            json.put("memSysLow", (Object)this.memSysLow);
            if (!this.handled.booleanValue()) {
                json.put("memSysTotal", (Object)this.memSysTotal);
                json.put("memSysAvailable", (Object)this.memSysAvailable);
            }
            json.put("memSysThreshold", (Object)this.memSysThreshold);
            json.put("memAppMax", (Object)this.memAppMax);
            json.put("memAppAvailable", (Object)this.memAppAvailable);
            json.put("memAppTotal", (Object)this.memAppTotal);
            if (Properties.SEND_LOG) {
                String logcat = Utils.readLogs();
                json.put("log", (Object)logcat);
            } else {
                json.put("log", (Object)"NA");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator((byte)0);
    }

    @Override
    public void send(boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save() {
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }
}

