package com.zoyi.channel.plugin.android.util.message_format.message;

import android.graphics.Typeface;
import android.support.v4.util.Pair;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;

import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RegexUtils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class EscapeMessage implements MessagePattern {

  public static final String ESCAPE_PREFIX = String.format("%c%c", 1, 2);
  public static final String ESCAPE_POSTFIX = String.format("%c%c", 3, 4);

  private Pattern escapePattern = Pattern.compile("\\\\[*<>\\[\\]\\\\]");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {


    for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(escapePattern.matcher(span))) {
      int start = range.first;
      int ascii = span.charAt(start + 1);

      span.delete(start, start + 2);
      span.insert(start, String.format("%s%d%s", ESCAPE_PREFIX, ascii, ESCAPE_POSTFIX));
    }

    return span;
  }
}
