package com.zoyi.channel.plugin.android.store2.state;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.store2.callback.MapStateCallback;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MapState<K, V> extends BaseState<Map<K, V>> {

  private ConcurrentHashMap<K, V> map;

  private MapStateCallback<K, V> callback;

  public MapState(MapStateCallback<K, V> callback) {
    super();
    this.callback = callback;
    this.map = new ConcurrentHashMap<>();
  }

  public void set(Collection<V> collection) {
    if (collection != null) {
      Set<K> oldKeySet = this.map.keySet();

      for (V value : collection) {
        oldKeySet.remove(callback.getKey(value));
      }

      for (K key : oldKeySet) {
        this.map.remove(key);
      }

      addOperation(collection, true);
      post();
    }
  }

  public void add(Collection<V> collection) {
    if (collection != null) {
      addOperation(collection, false);
      post();
    }
  }

  private void addOperation(Collection<V> collection, boolean set) {
    Map<K, V> addMap = new HashMap<>();

    for (V value : collection) {
      K key = callback.getKey(value);
      V oldbie = get(key);

      if (oldbie == null || set || canUpdate(oldbie, value)) {
        addMap.put(key, value);
      }
    }

    this.map.putAll(addMap);
  }

  public boolean upsert(V value) {
    if (value != null) {
      K key = callback.getKey(value);
      V oldbie = get(key);

      if (oldbie == null || canUpdate(oldbie, value)) {
        this.map.put(key, value);
        post();

        return true;
      }
    }
    return false;
  }

  public V remove(V value) {
    if (value != null) {
      V removedValue = this.map.remove(callback.getKey(value));
      post();

      return removedValue;
    }
    return null;
  }

  public void removeByKey(K key) {
    if (key != null) {
      V value = this.map.remove(key);

      if (value != null) {
        post();
      }
    }
  }

  public void clear() {
    this.map.clear();
    post();
  }

  @NonNull
  @Override
  public Map<K, V> get() {
    return this.map;
  }

  @Nullable
  public V get(K key) {
    if (key != null && this.map.containsKey(key)) {
      return this.map.get(key);
    }
    return null;
  }

  @Override
  public void reset() {
    this.map.clear();
  }

  protected boolean canUpdate(V oldbie, V newbie) {
    return true;
  }
}
