package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;

public class PluginAction {

  public static void fetchPlugin(String pluginId, boolean handleLoadingState) {
    if (handleLoadingState) {
      Store2.getInstance(PluginStore.class).pluginFetchState.set(FetchState.LOADING);
    }

    Api.getPlugin(pluginId)
        .runBy(ActionType.REQUEST_PLUGIN)
        .cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN)
        .run(new RestSubscriber<PluginWrapper>() {
          @Override
          public void onError(RetrofitException error) {
            Store2.getInstance(PluginStore.class).pluginFetchState.set(FetchState.FAILED);
          }

          @Override
          public void onSuccess(@NonNull PluginWrapper repo) {
            if (repo.getPlugin() != null) {
              Store2.getInstance(PluginStore.class).pluginState.set(repo.getPlugin());
            }

            if (repo.getChannel() != null) {
              Store2.getInstance(ChannelStore.class).channelState.set(repo.getChannel());
            }

            if (repo.getGuest() != null) {
              Store2.getInstance(GuestStore.class).guest.set(repo.getGuest());
            }

            if (repo.getBot() != null) {
              Store2.getInstance(BotStore.class).bots.upsert(repo.getBot());
              Store2.getInstance(BotStore.class).defaultBotId.set(repo.getBot().getId());
            }


            Store2.getInstance(PluginStore.class).pluginFetchState.set(FetchState.COMPLETE);
          }
        });
  }
}
