/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream.internal;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

public final class Compat {
    static final long MAX_ARRAY_SIZE = 0x7FFFFFF7L;
    private static final String BAD_SIZE = "Stream size exceeds max array size";

    public static <T> Queue<T> queue() {
        try {
            return new ArrayDeque();
        }
        catch (NoClassDefFoundError nce) {
            return new LinkedList();
        }
    }

    @SafeVarargs
    public static <E> E[] newArray(int length, E ... array) {
        try {
            return Arrays.copyOf(array, length);
        }
        catch (NoSuchMethodError nme) {
            return Compat.newArrayCompat(array, length);
        }
    }

    public static <E> E[] newArrayCompat(E[] array, int length) {
        Object[] res = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, res, 0, Math.min(length, array.length));
        return res;
    }

    static void checkMaxArraySize(long size) {
        if (size >= 0x7FFFFFF7L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
    }
}

