/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import java.util.List;

public class UIUtils {
    public static int getVisible(boolean visible, boolean gone) {
        return visible ? 0 : (gone ? 8 : 4);
    }

    public static String getNamesString(List<? extends ProfileEntity> profiles) {
        if (profiles == null || profiles.size() == 0) {
            return "Unknown";
        }
        String base = "";
        for (ProfileEntity profileEntity : profiles) {
            if (profileEntity == null || TextUtils.isEmpty((CharSequence)profileEntity.getName())) continue;
            if (TextUtils.isEmpty((CharSequence)base)) {
                base = profileEntity.getName();
                continue;
            }
            base = String.format("%s, %s", base, profileEntity.getName());
        }
        if (TextUtils.isEmpty((CharSequence)base)) {
            return "Unknown";
        }
        return base;
    }

    public static void showToast(Context context, String message) {
        Toast.makeText((Context)context, (CharSequence)message, (int)0).show();
    }

    public static void showAlertDialog(Context context, String message, boolean cancelable, AlertDialogListener listener) {
        UIUtils.showAlertDialog(context, message, context.getText(17039370).toString(), context.getText(0x1040000).toString(), null, cancelable, listener);
    }

    public static void showAlertDialog(Context context, String message, @Nullable String positive, @Nullable String negative, @Nullable String neutral, boolean cancelable, final AlertDialogListener listener) {
        block5: {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setMessage((CharSequence)message);
            builder.setCancelable(cancelable);
            if (positive != null) {
                builder.setPositiveButton((CharSequence)positive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (listener != null) {
                            listener.onPositive();
                        }
                    }
                });
            }
            if (negative != null) {
                builder.setNegativeButton((CharSequence)negative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (listener != null) {
                            listener.onNegative();
                        }
                    }
                });
            }
            if (neutral != null) {
                builder.setNeutralButton((CharSequence)neutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (listener != null) {
                            listener.onNeutral();
                        }
                    }
                });
            }
            AlertDialog alertDialog = builder.create();
            try {
                alertDialog.setCanceledOnTouchOutside(false);
                alertDialog.show();
            }
            catch (Exception ignored) {
                if (listener == null) break block5;
                listener.onError();
            }
        }
    }

    public static int getLauncherIcon(int chatCount, int textColor, boolean hasPushBotLocalChat) {
        boolean hasLauncherStroke;
        boolean bl = hasLauncherStroke = textColor == -16777216;
        if (hasLauncherStroke) {
            if (hasPushBotLocalChat) {
                return R.drawable.bubble_stroke_push;
            }
            if (chatCount <= 0) {
                return R.drawable.bubble_stroke;
            }
            if (chatCount < 10) {
                return R.drawable.bubble_stroke_up;
            }
            return R.drawable.bubble_stroke_up_right;
        }
        if (hasPushBotLocalChat) {
            return R.drawable.bubble_filled_push;
        }
        if (chatCount <= 0) {
            return R.drawable.bubble_filled;
        }
        if (chatCount < 10) {
            return R.drawable.bubble_filled_up;
        }
        return R.drawable.bubble_filled_up_right;
    }
}

