package com.zoyi.channel.plugin.android.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ObjectUtils {

  private ObjectUtils() { }

  @NonNull
  public static Map<String, Object> toMap(@Nullable Object object) {
    Map<String, Object> map = new HashMap<>();

    if (object != null) {
      Field[] fields = object.getClass().getDeclaredFields();

      for (Field field : fields) {
        field.setAccessible(true);
        try {
          String fieldName = field.getName();

          if (!"CLASSNAME".equals(fieldName)) {
            map.put(field.getName(), field.get(object));
          }
        } catch (Exception e) {
          e.printStackTrace();
        }
      }
    }

    return map;
  }
}
