package com.zoyi.channel.plugin.android.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelIO;

public class ClipboardUtils {
  private ClipboardUtils() {}

  public static boolean copyToClipBoard(@Nullable String text) {
    ClipboardManager clipboardManager = (ClipboardManager) ChannelIO.getAppContext().getSystemService(Context.CLIPBOARD_SERVICE);

    if (clipboardManager != null && text != null) {
      clipboardManager.setPrimaryClip(ClipData.newPlainText("label", text));
      return true;
    }

    return false;
  }
}
