package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.Manifest;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerContract;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;

import java.util.ArrayList;

/**
 * Created by mika on 8/31/16.
 */
public class PhotoPickerActivity extends BaseActivity2 implements PhotoPickerContract.View {

  private LinearLayout emptyLayout;

  private NavigationView navigation;

  private PhotoPickerContract.Presenter presenter;

  private RxPermissions rxPermissions;

  @Nullable
  private View buttonDone;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_photo_picker);

    rxPermissions = new RxPermissions(this);

    RecyclerView recyclerView = findViewById(R.id.recycler_view_photo_picker);

    PhotoPickerAdapter adapter = new PhotoPickerAdapter(this);

    presenter = new PhotoPickerPresenter(this, this, adapter, adapter);

    emptyLayout = findViewById(R.id.no_album);
    navigation = findViewById(R.id.navigationPhotoPicker);
    navigation.addAction(R.drawable.ch_plugin_ic_photo_camera_white_24dp, 24, (v) -> openCamera());
    buttonDone = navigation.addAction(R.drawable.ch_plugin_ic_done_white_24dp, 24, (v) -> sendPhotoPaths(presenter.getSelectedPaths()) );

    recyclerView.setLayoutManager(new GridLayoutManager(this, Const.COLUMNS_PHOTO_PICKER));
    recyclerView.setAdapter(adapter);
    recyclerView.setItemAnimator(null);

    bindPresenter(presenter);

    fetchPhotoItems();

    return true;
  }

  @Override
  public void onBackPressed() {
    setResult(RESULT_CANCELED);
    super.onBackPressed();
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (resultCode == RESULT_OK) {
      switch (requestCode) {
        case Const.REQUEST_TAKE_PHOTO:
          String photoPath = Executor.getPhotoPath();

          if (!TextUtils.isEmpty(photoPath)) {
            Executor.startFileMediaScan(this, photoPath);

            sendPhotoPath(Executor.getPhotoPath());
          }
          return;
      }
    }
    super.onActivityResult(requestCode, resultCode, data);
  }

  private void sendPhotoPath(String photoPath) {
    ArrayList<String> photoPaths = new ArrayList<>();

    photoPaths.add(photoPath);

    sendPhotoPaths(photoPaths);
  }

  @Override
  public void loadPhotoItems(ArrayList<PhotoItem> photoItems) {
    setEmptyLayoutVisibility(photoItems.isEmpty());
  }

  @Override
  public void sendPhotoPaths(ArrayList<String> imagePaths) {
    Intent i = new Intent();
    i.putStringArrayListExtra(Const.PHOTO_INTENT_KEY, imagePaths);

    setResult(Const.RESULT_PHOTO_CODE, i);
    finish();
  }

  @Override
  public void showLimitPopup() {
    Toast.makeText(
        this,
        ResUtils.getString(this, "ch.photo.limit_alert"),
        Toast.LENGTH_LONG
    ).show();
  }

  private void setEmptyLayoutVisibility(boolean visible) {
    emptyLayout.setVisibility(visible ? View.VISIBLE : View.GONE);
  }

  private void fetchPhotoItems() {
    rxPermissions.request(Manifest.permission.WRITE_EXTERNAL_STORAGE).subscribe(granted -> {
      if (granted) {
        fetchPhotoItemsPermissionAccepted();
      } else {
        showDeniedToast();
      }
    });
  }

  private void fetchPhotoItemsPermissionAccepted() {
    presenter.fetchPhotoItems();
  }

  private void openCamera() {
    if (!Utils.hasPermissionInManifest(this, Manifest.permission.CAMERA)) {
      openCameraPermissionAccepted();
    } else {
      rxPermissions.request(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.CAMERA).subscribe(granted -> {
        if (granted) {
          openCameraPermissionAccepted();
        } else {
          showDeniedToast();
        }
      });
    }
  }

  private void openCameraPermissionAccepted() {
    if (!Executor.takePhoto(this)) {
      showDeniedToast();
    }
  }

  private void showDeniedToast() {
    Toast.makeText(
        this,
        ResUtils.getString(this, "ch.permission.denied"),
        Toast.LENGTH_LONG
    ).show();
  }

  @Override
  public void onSelectChange(int count) {
    if (buttonDone != null) {
      buttonDone.setEnabled(count > 0);
    }
  }
}
