/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

public class CustomMovementMethod
extends LinkMovementMethod {
    private static CustomMovementMethod sInstance;

    public boolean canSelectArbitrarily() {
        return true;
    }

    public void initialize(TextView widget, Spannable text) {
        Selection.setSelection((Spannable)text, (int)text.length());
    }

    public void onTakeFocus(TextView view, Spannable text, int dir) {
        if ((dir & 0x82) != 0) {
            if (view.getLayout() == null) {
                Selection.setSelection((Spannable)text, (int)text.length());
            }
        } else {
            Selection.setSelection((Spannable)text, (int)text.length());
        }
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)widget);
                } else if (action == 0) {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                }
                return true;
            }
        }
        return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
    }

    public static CustomMovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new CustomMovementMethod();
        }
        return sInstance;
    }
}

