/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockingOperatorLatest {
    private BlockingOperatorLatest() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Iterable<T> latest(final Observable<? extends T> source) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                LatestObserverIterator lio = new LatestObserverIterator();
                source.materialize().subscribe(lio);
                return lio;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LatestObserverIterator<T>
    extends Subscriber<Notification<? extends T>>
    implements Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<? extends T>> value = new AtomicReference();
        Notification<? extends T> iteratorNotification;

        LatestObserverIterator() {
        }

        @Override
        public void onNext(Notification<? extends T> args) {
            boolean wasNotAvailable;
            boolean bl = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw Exceptions.propagate(this.iteratorNotification.getThrowable());
            }
            if (!(this.iteratorNotification != null && this.iteratorNotification.isOnCompleted() || this.iteratorNotification != null)) {
                Notification n;
                try {
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    this.unsubscribe();
                    Thread.currentThread().interrupt();
                    this.iteratorNotification = Notification.createOnError(ex);
                    throw Exceptions.propagate(ex);
                }
                this.iteratorNotification = n = (Notification)this.value.getAndSet(null);
                if (this.iteratorNotification.isOnError()) {
                    throw Exceptions.propagate(this.iteratorNotification.getThrowable());
                }
            }
            return !this.iteratorNotification.isOnCompleted();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iteratorNotification.isOnNext()) {
                T v = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

