package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

import java.util.List;

public class PhotoAlbumPagerAdapter extends PagerAdapter {

  private Context context;
  private PhotoViewAttacher.OnPhotoTapListener listener;
  private LayoutInflater inflater;
  @NonNull
  private List<FileMeta> filemetas;

  public PhotoAlbumPagerAdapter(Context context, @NonNull List<FileMeta> filemetas, PhotoViewAttacher.OnPhotoTapListener listener) {
    this.context = context;
    inflater = LayoutInflater.from(context);
    this.filemetas = filemetas;
    this.listener = listener;
  }

  @Nullable
  public FileMeta getItem(int position) {
    if (position >= 0 && position < filemetas.size()) {
      return filemetas.get(position);
    }
    return null;
  }

  @Override
  public int getCount() {
    return filemetas.size();
  }

  @Override
  public int getItemPosition(Object item) {
    return POSITION_NONE;
  }

  @Override
  public boolean isViewFromObject(View view, Object object) {
    return view.equals(object);
  }

  @Override
  public void destroyItem(ViewGroup container, int position, Object object) {
    if (container != null && object != null && object instanceof View) {
      container.removeView((View) object);
    }
  }

  @Override
  public Object instantiateItem(ViewGroup container, int position) {
    FileMeta fileMeta = filemetas.get(position);
    View view = inflater.inflate(R.layout.ch_plugin_item_photo_album, container, false);
    PhotoView photoView = view.findViewById(R.id.iv_accessary_image);
    photoView.setOnPhotoTapListener(listener);

    Glide.with(context)
        .load(fileMeta.getUrl())
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .dontAnimate()
        .into(photoView);

    container.addView(view);

    return view;
  }
}
