package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.MessageAction;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;

/**
 * Created by jerry on 2018. 10. 22..
 */

public class ChatMessageHolder extends ContentMessageHolder {

  public static ChatMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnMessageContentClickListener onMessageContentClickListener
  ) {
    return new ChatMessageHolder(getItemView(parent, messageType), messageType, onMessageContentClickListener);
  }

  private ChatMessageHolder(View itemView, MessageType messageType, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    super(itemView, messageType, onMessageContentClickListener);
  }

  public void bind(ChatMessageItem chatMessageItem, boolean isConnectedMessage, boolean isLastMessage) {
    Message message = chatMessageItem.getMessage();

    super.bind(message, chatMessageItem.getType(), isConnectedMessage);

    if (message != null) {
      if (message.getFile() != null) {
        bindFile(message.getFile());
      }

      if (message.getWebPage() != null) {
        setWebPage(message.getWebPage());
      }

      if (message.getAction() != null && isLastMessage) {
        MessageAction messageAction = message.getAction();
        setAction(messageAction.getType(), messageAction.getButtons());
      }

      if (message.shouldTranslate() && chatMessageItem.getType() == MessageType.HOST) {
        setTranslationButton(message, isConnectedMessage);
      }

      if (message.hasButtons()) {
        setMessageButtons(message.getButtons());
      }
    }
  }

  protected void bindFile(File file) {
    if (file.isImage()) {
      if (file.getImageRedirectUrl() != null) {
        setLinkableImage(file.getPreviewThumb());
      } else {
        setImage(file.getPreviewThumb());
      }
    } else {
      setFileDescription(file);
    }
  }

  @Override
  protected void onLinkableImageClick() {
    if (onMessageContentClickListener != null && message != null && message.getFile() != null) {
      onMessageContentClickListener.onRedirectContentsClick(message.getFile().getImageRedirectUrl());
    }
  }
}
