/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.util.ExceptionsUtils;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeFlatMapCompletable<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final Func1<? super T, ? extends Completable> mapper;
    final boolean delayErrors;
    final int maxConcurrency;

    public OnSubscribeFlatMapCompletable(Observable<T> source, Func1<? super T, ? extends Completable> mapper, boolean delayErrors, int maxConcurrency) {
        if (mapper == null) {
            throw new NullPointerException("mapper is null");
        }
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        FlatMapCompletableSubscriber<? super T> parent = new FlatMapCompletableSubscriber<T>(child, this.mapper, this.delayErrors, this.maxConcurrency);
        child.add(parent);
        child.add(parent.set);
        this.source.unsafeSubscribe(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FlatMapCompletableSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<? super T, ? extends Completable> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicInteger wip;
        final CompositeSubscription set;
        final AtomicReference<Throwable> errors;

        FlatMapCompletableSubscriber(Subscriber<? super T> actual, Func1<? super T, ? extends Completable> mapper, boolean delayErrors, int maxConcurrency) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.wip = new AtomicInteger(1);
            this.errors = new AtomicReference();
            this.set = new CompositeSubscription();
            this.request(maxConcurrency != Integer.MAX_VALUE ? (long)maxConcurrency : Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            Completable c;
            try {
                c = this.mapper.call(t);
                if (c == null) {
                    throw new NullPointerException("The mapper returned a null Completable");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
                return;
            }
            InnerSubscriber inner = new InnerSubscriber();
            this.set.add(inner);
            this.wip.getAndIncrement();
            c.unsafeSubscribe(inner);
        }

        @Override
        public void onError(Throwable e) {
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e);
                this.onCompleted();
            } else {
                this.set.unsubscribe();
                if (this.errors.compareAndSet(null, e)) {
                    this.actual.onError(ExceptionsUtils.terminate(this.errors));
                } else {
                    RxJavaHooks.onError(e);
                }
            }
        }

        @Override
        public void onCompleted() {
            this.done();
        }

        boolean done() {
            if (this.wip.decrementAndGet() == 0) {
                Throwable ex = ExceptionsUtils.terminate(this.errors);
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onCompleted();
                }
                return true;
            }
            return false;
        }

        public void innerError(InnerSubscriber inner, Throwable e) {
            this.set.remove(inner);
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e);
                if (!this.done() && this.maxConcurrency != Integer.MAX_VALUE) {
                    this.request(1L);
                }
            } else {
                this.set.unsubscribe();
                this.unsubscribe();
                if (this.errors.compareAndSet(null, e)) {
                    this.actual.onError(ExceptionsUtils.terminate(this.errors));
                } else {
                    RxJavaHooks.onError(e);
                }
            }
        }

        public void innerComplete(InnerSubscriber inner) {
            this.set.remove(inner);
            if (!this.done() && this.maxConcurrency != Integer.MAX_VALUE) {
                this.request(1L);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements CompletableSubscriber,
        Subscription {
            private static final long serialVersionUID = -8588259593722659900L;

            InnerSubscriber() {
            }

            @Override
            public void unsubscribe() {
                Subscription s = this.getAndSet(this);
                if (s != null && s != this) {
                    s.unsubscribe();
                }
            }

            @Override
            public boolean isUnsubscribed() {
                return this.get() == this;
            }

            @Override
            public void onCompleted() {
                FlatMapCompletableSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapCompletableSubscriber.this.innerError(this, e);
            }

            @Override
            public void onSubscribe(Subscription d) {
                if (!this.compareAndSet(null, d)) {
                    d.unsubscribe();
                    if (this.get() != this) {
                        RxJavaHooks.onError(new IllegalStateException("Subscription already set!"));
                    }
                }
            }
        }
    }
}

