/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.util.draw.Display;
import java.util.HashMap;
import java.util.Map;

public class Event {
    private String name;
    private Map<String, Object> property;
    private Map<String, Object> sysProperty;

    public Event(@NonNull String name, @Nullable Map<String, Object> property) {
        this.name = name;
        this.property = property;
        this.sysProperty = new HashMap<String, Object>();
        this.initSysProperty(this.sysProperty);
    }

    private void initSysProperty(Map<String, Object> sysProperty) {
        Object url;
        sysProperty.put("pluginVersion", "5.4.5");
        Object object = url = this.property != null ? this.property.get("url") : null;
        if (url instanceof String) {
            sysProperty.put("url", url);
        } else {
            Activity topActivity = GlobalStore.get().topActivity.get();
            if (topActivity != null) {
                sysProperty.put("url", topActivity.getClass().getSimpleName());
            }
        }
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            sysProperty.put("screenWidth", Display.getWidth(context));
            sysProperty.put("screenHeight", Display.getHeight(context));
        }
    }
}

