package com.zoyi.channel.plugin.android.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.webkit.WebView;

/**
 * Created by jerry on 2018. 9. 3..
 */

public class UriUtils {

  private static final String INTENT_URI_PREFIX = "intent:";
  private static final String FALLBACK_URL_PREFIX = "browser_fallback_url";

  public static boolean isIntentUri(@Nullable String uri) {
    return uri != null && uri.toLowerCase().startsWith(INTENT_URI_PREFIX);
  }

  public static boolean doFallBack(@Nullable Context context, @Nullable Intent parsedIntent) {
    if (context == null || parsedIntent == null) {
      return false;
    }

    String fallbackUrl = parsedIntent.getStringExtra(FALLBACK_URL_PREFIX);

    if (fallbackUrl != null) {
      try {
        context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(fallbackUrl)));
        return true;
      } catch (Exception exception) { }
    }

    return false;
  }
}
