package com.zoyi.channel.plugin.android.activity.chats;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat3.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsContract;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.scrollview.RecyclerBottomPlaceholderLayout;

public class ChatsActivity extends BaseActivity2 implements ChatsContract.View, OnChatClickListener {

  private NavigationView navigation;

  private View layoutChats;
  private View progressChats;
  private View viewChatsError;

  private RecyclerView recyclerViewChats;
  private View viewChatsEmpty;

  private RecyclerBottomPlaceholderLayout bottomLayoutChats;

  private ChatStartButton startButton;

  private ChatsAdapter adapter;
  private ChatsContract.Presenter presenter;

  private LinearLayoutManager layoutManager;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_chats);

    navigation = findViewById(R.id.navigationChats);
    navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));

    layoutChats = findViewById(R.id.layoutChats);
    viewChatsError = findViewById(R.id.layoutErrorRefreshChats);

    adapter = new ChatsAdapter();
    adapter.setListener(this);

    layoutManager = new LinearLayoutManager(this);

    recyclerViewChats = findViewById(R.id.recyclerViewChats);
    recyclerViewChats.setLayoutManager(layoutManager);
    recyclerViewChats.setAdapter(adapter);
    recyclerViewChats.setItemAnimator(null);
    recyclerViewChats.getRecycledViewPool().setMaxRecycledViews(0, 40);

    startButton = findViewById(R.id.buttonChatsStartNewChat);
    startButton.setOnClickListener((v) -> startNewChat());

    progressChats = findViewById(R.id.progressChats);
    viewChatsEmpty = findViewById(R.id.layoutChatsEmpty);

    bottomLayoutChats = findViewById(R.id.bottomLayoutChats);
    bottomLayoutChats.setRecyclerView(recyclerViewChats);

    presenter = new ChatsPresenter(this, adapter, adapter);

    bindPresenter(presenter);

    return true;
  }

  @Override
  public void onChatsCountChange(int count) {
    if (count > 0) {
      recyclerViewChats.setVisibility(View.VISIBLE);
      viewChatsEmpty.setVisibility(View.GONE);
    } else {
      recyclerViewChats.setVisibility(View.GONE);
      viewChatsEmpty.setVisibility(View.VISIBLE);
    }
  }

  @Override
  public void onUserChatsFetchStateChange(FetchState fetchState) {
    layoutChats.setVisibility(View.GONE);
    progressChats.setVisibility(View.GONE);
    viewChatsError.setVisibility(View.GONE);

    switch (fetchState) {
      case LOADING:
        progressChats.setVisibility(View.VISIBLE);
        break;

      case FAILED:
        viewChatsError.setVisibility(View.VISIBLE);
        break;

      case COMPLETE:
        layoutChats.setVisibility(View.VISIBLE);
        break;
    }
  }

  @Override
  public void onChatItemClick(@NonNull ChatItem chatItem) {
    ChatUtils.createChatActivityIntent(this)
        .putExtra(Const.EXTRA_CHAT_CONTENT_TYPE, chatItem.getType().toString())
        .putExtra(Const.EXTRA_CHAT_CONTENT_ID, chatItem.getSubKey())
        .startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startNewChat() {
    ChatUtils.createChatActivityIntent(this).startActivityForResult(Const.REQUEST_CHAT);
  }

  @Override
  public void onChatItemLongClick(@NonNull ChatItem chatItem) {
    new ChannelDialog(this)
        .setDescription(ResUtils.getString("ch.chat.delete_description"))
        .addButton(ButtonType.CANCEL)
        .addButton(ButtonType.OK, (v) -> presenter.removeChat(chatItem))
        .allowBackpress(true)
        .show();
  }

  @Override
  public boolean isOnTop() {
    return !recyclerViewChats.canScrollVertically(-1);
  }

  @Override
  public void scrollToTop() {
    layoutManager.scrollToPosition(0);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    if (requestCode == Const.REQUEST_CHAT && resultCode == Const.RESULT_CHAT_OPEN_NEW_CHAT) {
      ChatUtils.createChatActivityIntent(this)
          .setTransition(Transition.NONE)
          .startActivityForResult(Const.REQUEST_CHAT);
    }
  }
}
