/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class UserChatItem
implements ChatItem {
    private UserChat userChat;
    @Nullable
    private Message message;
    @Nullable
    private Session session;
    @Nullable
    private ProfileEntity profileEntity;

    public UserChatItem(UserChat userChat, @Nullable Message message, @Nullable Session session, @Nullable ProfileEntity profileEntity) {
        this.userChat = userChat;
        this.message = message;
        this.session = session;
        this.profileEntity = profileEntity;
    }

    @Override
    @Nullable
    public String getId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    @Override
    @Nullable
    public ProfileEntity getProfile() {
        if (this.profileEntity != null) {
            return this.profileEntity;
        }
        return ChannelStore.get().channelState.get();
    }

    @Override
    @Nullable
    public Long getUpdatedAt() {
        if (this.userChat != null && this.userChat.isStateClosed() && this.userChat.getClosedAt() != null) {
            return this.userChat.getClosedAt();
        }
        if (this.userChat != null && this.userChat.getUpdatedAt() != null) {
            return this.userChat.getUpdatedAt();
        }
        return null;
    }

    @Override
    @NonNull
    public String getMessage() {
        if (this.userChat != null && this.userChat.getReview() != null) {
            return ResUtils.getString("ch.review.complete.preview");
        }
        if (this.message != null) {
            if (this.message.getMessage() != null) {
                return this.message.getMessage();
            }
            if (this.message.getFile() != null) {
                if (this.message.getFile().isImage()) {
                    return ResUtils.getString("ch.notification.upload_image.description");
                }
                return ResUtils.getString("ch.notification.upload_file.description");
            }
        }
        return "";
    }

    @Override
    public boolean isActive() {
        if (this.userChat != null) {
            return this.userChat.getReview() == null && !this.userChat.isStateClosed();
        }
        return true;
    }

    @Override
    public int getCount() {
        if (this.session != null && this.session.getAlert() != null) {
            return this.session.getAlert();
        }
        return 0;
    }

    @Override
    @Nullable
    public String getSubKey() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    @Override
    public ChatContentType getType() {
        return ChatContentType.USER_CHAT;
    }
}

