package com.zoyi.channel.plugin.android.activity.chat3.contract;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat3.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

import java.util.ArrayList;
import java.util.List;

public interface ChatContract {

  interface View extends BaseView {

    void onFetchStateChange(FetchState fetchState);

    void onWelcomeStateChange(ChatContentType contentType, boolean acceptInput);

    void setPushBotSaveButtonVisibility(boolean visible);

    void onChatStateChange(UserChat userChat, boolean acceptInput, boolean temporaryInputOpened);

    boolean isScrollOnBottom();

    void scrollToBottom();

    void showNewMessageAlert(ProfileEntity profileEntity);

    void showCountryDialog(List<Country> countries, ProfileBotMessageItem item);

    void setInputDim(boolean enabled);
  }

  interface Presenter extends BaseAdapterPresenter {

    void createPushBotChat();

    void fetchBackwardMessages();

    void sendText(String message);

    void uploadFiles(ArrayList<String> paths);

    void translate(Message message);

    void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton);

    void resend(SendingMessageItem item);

    void removeFailedItem(SendingMessageItem item);

    void requestCountries(ProfileBotMessageItem item);

    void selectCountry(String countryCode, ProfileBotMessageItem item);

    void updateProfile(ProfileBotMessageItem item);
  }
}
