/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.ChannelAction;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.selector2.ChannelSelector;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.layout.FetchLayout;
import com.zoyi.rx.functions.Action4;

public class LoungeIntegrationsView
extends FetchLayout {
    private Context context;
    private View buttonKakao;
    private View buttonLink;
    private View buttonPhone;
    private RxPermissions rxPermissions;
    @Nullable
    private String kakaoLink;
    @Nullable
    private String defaultPluginLink;
    @Nullable
    private String phoneNumber;
    @Nullable
    private Binder binder;

    public LoungeIntegrationsView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LoungeIntegrationsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoungeIntegrationsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.rxPermissions = new RxPermissions((Activity)context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_lounge_integrations, (ViewGroup)this, true);
        this.buttonKakao = view.findViewById(R.id.buttonIntegrationsKakao);
        this.buttonKakao.setOnClickListener(v -> this.openUrl(this.kakaoLink));
        this.buttonLink = view.findViewById(R.id.buttonIntegrationsLink);
        this.buttonLink.setOnClickListener(v -> this.copyText(this.defaultPluginLink));
        this.buttonPhone = view.findViewById(R.id.buttonIntegrationsPhone);
        this.buttonPhone.setOnClickListener(v -> this.call(this.phoneNumber));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = ChannelSelector.bindIntegrations((Action4<FetchState, Channel, Plugin, MessengersRepo>)((Action4)(fetchState, channel, plugin, repo) -> {
            switch (fetchState) {
                case LOADING: 
                case FAILED: {
                    this.setVisibility(0);
                    this.setFetchState((FetchState)((Object)fetchState));
                    break;
                }
                case COMPLETE: {
                    int activeCount = 0;
                    if (repo != null && repo.getAppKakaoLink() != null) {
                        this.kakaoLink = repo.getAppKakaoLink();
                        this.buttonKakao.setVisibility(0);
                        ++activeCount;
                    } else {
                        this.kakaoLink = null;
                        this.buttonKakao.setVisibility(8);
                    }
                    if (channel != null && plugin != null && channel.getDomain() != null && channel.getDefaultPluginId() != null && channel.getDefaultPluginId().equals(plugin.getId())) {
                        this.defaultPluginLink = String.format("https://%s.channel.io", channel.getDomain());
                        this.buttonLink.setVisibility(0);
                        ++activeCount;
                    } else {
                        this.defaultPluginLink = null;
                        this.buttonLink.setVisibility(8);
                    }
                    if (channel != null && channel.getPhoneNumber() != null) {
                        this.phoneNumber = channel.getPhoneNumber();
                        this.buttonPhone.setVisibility(0);
                        ++activeCount;
                    } else {
                        this.phoneNumber = null;
                        this.buttonPhone.setVisibility(8);
                    }
                    Views.setVisibility((View)this, activeCount > 0);
                    this.setFetchState(FetchState.COMPLETE);
                }
            }
        }));
    }

    private void openUrl(@Nullable String url) {
        if (url != null) {
            IntentUtils.setUrl(this.context, url).startActivity();
        }
    }

    private void copyText(@Nullable String text) {
        if (text != null && ClipboardUtils.copyToClipBoard(text)) {
            Toast.makeText((Context)this.context, (CharSequence)ResUtils.getString("ch.integrations.copy_link.success"), (int)0).show();
        }
    }

    private void call(@Nullable String number) {
        if (number != null) {
            this.rxPermissions.request("android.permission.CALL_PHONE").subscribe(granted -> {
                if (granted.booleanValue()) {
                    Executor.call(this.context, number);
                } else {
                    Toast.makeText((Context)this.context, (CharSequence)ResUtils.getString("ch.permission.denied"), (int)1).show();
                }
            });
        }
    }

    protected void onDetachedFromWindow() {
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void onRefreshClick() {
        ChannelAction.fetchMessengers();
    }
}

