package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 12..
 */
public class DateItem implements MessageItem {
  private Long timestamp;
  private final static Long cutOff = 24L * 60L * 60L * 1000L;

  public DateItem(Long timestamp) {
    this.timestamp = ((timestamp + TimeUtils.TIME_ZONE_OFFSET) / cutOff) * cutOff - TimeUtils.TIME_ZONE_OFFSET;
  }

  public String getDate() {
    return TimeUtils.get(TimeUtils.FULL_DAY, timestamp);
  }

  @Override
  public Long getPrimaryKey() {
    return timestamp;
  }

  @Override
  public String getSecondaryKey() {
    return "DateItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.DATE;
  }
}
