/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.CHHeaderView;
import com.zoyi.channel.plugin.android.view.handler.ButtonTouchHandler;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigBar
extends LinearLayout {
    private static final int MENU_BUTTON_WIDTH = 40;
    private static final int MENU_TEXT_WIDTH = 32;
    private static final int TITLE_LAYOUT_MARGIN = 16;
    private RelativeLayout layout;
    private LinearLayout leftLayout;
    private LinearLayout rightLayout;
    private CHTextView textTitle;
    private FrameLayout titleLayout;
    private FrameLayout frameCustomHeader;
    private Context context;
    @Nullable
    private BaseActivity activity;
    private Animation pushAnimation;
    private Map<Integer, CHTextView> textMap;
    private List<MenuButton> buttons;
    private boolean init = false;
    @ColorInt
    private int backgroundColor = -16777216;
    @ColorInt
    private int textColor = -1;
    @Nullable
    private CHHeaderView headerView;

    public BigBar(Context context) {
        super(context);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BigBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public BigBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_bigbar, (ViewGroup)this, true);
        this.layout = (RelativeLayout)this.findViewById(R.id.bar_layout);
        this.leftLayout = (LinearLayout)this.findViewById(R.id.layout_left);
        this.rightLayout = (LinearLayout)this.findViewById(R.id.layout_right);
        this.textTitle = (CHTextView)this.findViewById(R.id.bar_title_main);
        this.titleLayout = (FrameLayout)this.findViewById(R.id.layout_title);
        this.frameCustomHeader = (FrameLayout)this.findViewById(R.id.frameBigbarHeader);
        this.textMap = new HashMap<Integer, CHTextView>();
        this.buttons = new ArrayList<MenuButton>();
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ch_plugin_push);
        this.pushAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public BigBar withActivity(@Nullable BaseActivity activity) {
        this.activity = activity;
        return this;
    }

    public BigBar addMenu(MenuButton.ActionType actionType, MenuPosition menuPosition) {
        return this.addMenu(actionType, menuPosition, MenuButton.MenuState.VISIBLE);
    }

    public BigBar addMenu(final MenuButton.ActionType actionType, MenuPosition menuPosition, MenuButton.MenuState menuState) {
        MenuButton menuButton = new MenuButton(this.context);
        menuButton.setAction(actionType);
        menuButton.setColor(this.textColor);
        menuButton.setMenuPosition(menuPosition);
        menuButton.setOnTouchListener(new ButtonTouchHandler((View)menuButton));
        menuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BigBar.this.eventRaised(actionType);
            }
        });
        this.setViewState((View)menuButton, menuState);
        this.addView((View)menuButton, menuPosition);
        this.buttons.add(menuButton);
        return this;
    }

    public BigBar addText(MenuPosition menuPosition) {
        return this.addText(0, menuPosition, "");
    }

    public BigBar addText(MenuPosition menuPosition, String string2) {
        return this.addText(0, menuPosition, string2);
    }

    private BigBar addText(int id2, MenuPosition menuPosition, String string2) {
        if (!this.textMap.containsKey(id2)) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)Utils.dpToPx(this.context, 32.0f), -2);
            params.weight = 1.0f;
            params.leftMargin = MenuPosition.LEFT.equals((Object)menuPosition) ? (int)Utils.dpToPx(this.context, 8.0f) * -1 : 0;
            params.rightMargin = MenuPosition.RIGHT.equals((Object)menuPosition) ? (int)Utils.dpToPx(this.context, 8.0f) * -1 : 0;
            params.gravity = 0x10 | (MenuPosition.LEFT.equals((Object)menuPosition) ? 0x800003 : 0x800005);
            CHTextView textView = new CHTextView(this.context);
            textView.setTypeface(textView.getTypeface(), 1);
            textView.setTextSize(2, 14.0f);
            textView.setTextColor(this.textColor);
            textView.setLayoutParams((ViewGroup.LayoutParams)params);
            textView.setText(string2);
            this.textMap.put(id2, textView);
            this.addView((View)textView, menuPosition);
        }
        return this;
    }

    public void setText(int number) {
        if (this.textMap.size() == 1) {
            this.setText(this.textMap.entrySet().iterator().next().getKey(), number);
        }
    }

    public void setText(int id2, int number) {
        CHTextView chTextView = this.textMap.get(id2);
        if (this.textMap.containsKey(id2) && chTextView != null) {
            chTextView.setText(Utils.getCount(number, true));
        }
    }

    public void setMenuState(MenuButton.ActionType actionType, MenuButton.MenuState buttonState) {
        if (actionType == null) {
            return;
        }
        for (MenuButton menuButton : this.buttons) {
            if (!actionType.equals((Object)menuButton.getAction())) continue;
            this.setViewState((View)menuButton, buttonState);
        }
    }

    public BigBar setHeaderView(@Nullable CHHeaderView headerView) {
        if (headerView != null) {
            this.textTitle.setVisibility(8);
            this.headerView = headerView;
            headerView.onTextColorChange(this.textColor);
            this.frameCustomHeader.addView((View)headerView);
            this.frameCustomHeader.setVisibility(0);
        }
        return this;
    }

    public BigBar setTitle(String text) {
        this.textTitle.setText(text);
        return this;
    }

    public BigBar setTitleByKey(String textKey) {
        this.textTitle.setTextByKey(textKey);
        return this;
    }

    public BigBar setTheme(@ColorInt int backgroundColor, @ColorInt int textColor) {
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
        this.layout.setBackgroundColor(backgroundColor);
        this.textTitle.setTextColor(textColor);
        if (this.headerView != null) {
            this.headerView.onTextColorChange(textColor);
        }
        for (CHTextView textView : this.textMap.values()) {
            textView.setTextColor(textColor);
        }
        for (MenuButton menuButton : this.buttons) {
            menuButton.setColor(textColor);
        }
        return this;
    }

    public void hide() {
        this.layout.setVisibility(8);
    }

    public void build() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.setTitleLayoutMargin();
    }

    private void setViewState(View view, MenuButton.MenuState menuState) {
        if (menuState == null) {
            return;
        }
        switch (menuState) {
            case VISIBLE: {
                view.setVisibility(0);
                view.setAlpha(1.0f);
                view.setEnabled(true);
                break;
            }
            case DISABLED: {
                view.setVisibility(0);
                view.setAlpha(0.3f);
                view.setEnabled(false);
                break;
            }
            case HIDDEN: {
                view.setVisibility(8);
            }
        }
        this.setTitleLayoutMargin();
    }

    private int getMarginForTitle() {
        int left = 16;
        int right = 16;
        if (this.textMap.size() > 0) {
            left += 32;
        }
        for (MenuButton button : this.buttons) {
            switch (button.getMenuPosition()) {
                case LEFT: {
                    if (!button.isVisible()) break;
                    left += 40;
                    break;
                }
                case RIGHT: {
                    if (!button.isVisible()) break;
                    right += 40;
                }
            }
        }
        return (int)Math.max(Utils.dpToPx(this.context, left), Utils.dpToPx(this.context, right));
    }

    private void setTitleLayoutMargin() {
        int margin = this.getMarginForTitle();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.titleLayout.getLayoutParams();
        layoutParams.leftMargin = margin;
        layoutParams.rightMargin = margin;
        this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void addView(View view, MenuPosition menuPosition) {
        if (MenuPosition.LEFT.equals((Object)menuPosition)) {
            this.leftLayout.addView(view);
        } else {
            this.rightLayout.addView(view);
        }
    }

    private void eventRaised(MenuButton.ActionType actionType) {
        if (this.activity != null) {
            this.activity.optionClicked(actionType);
        }
    }

    public static enum MenuPosition {
        LEFT,
        RIGHT;

    }
}

