/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.CHHeaderView;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class ChatHeaderView
extends CHHeaderView {
    private Context context;
    private CHTextView textTitle;
    private CHTextView textDescription;
    private ImageView imageLeft;
    private ImageView imageRight;
    @Nullable
    private Channel channel;
    @Nullable
    private UserChat userChat;
    private boolean expand;

    public ChatHeaderView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    @Initializer
    public void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_chat_header, (ViewGroup)this, true);
        this.context = context;
        this.textTitle = (CHTextView)view.findViewById(R.id.textChatHeaderTitle);
        this.textDescription = (CHTextView)view.findViewById(R.id.textChatHeaderDescription);
        this.imageLeft = (ImageView)view.findViewById(R.id.imageChatHeaderLeftImage);
        this.imageRight = (ImageView)view.findViewById(R.id.imageChatHeaderRightImage);
    }

    public void bindChannel(@Nullable Channel channel) {
        this.channel = channel;
        this.setStyle(channel, this.userChat, this.expand);
    }

    public void bindUserChat(@Nullable UserChat userChat) {
        this.userChat = userChat;
        this.setStyle(this.channel, userChat, this.expand);
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
        this.setStyle(this.channel, this.userChat, expand);
    }

    private void setStyle(@Nullable Channel channel, @Nullable UserChat userChat, boolean expand) {
        this.imageRight.setRotation(expand ? -180.0f : 0.0f);
        if (userChat == null || userChat.getHostType() == null || userChat.getHostId() == null) {
            this.imageLeft.setImageResource(ChatResponseManager.getResponseSymbol(channel));
            this.textTitle.setText(channel == null ? ResUtils.getString(this.context, "ch.unknown") : channel.getName());
            this.textDescription.setTextByKey(ChatResponseManager.getShortResponseDescriptionKey(channel));
            Views.setVisibility((View)this.textDescription, !expand);
        } else {
            ProfileEntity entity = ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());
            this.imageLeft.setImageResource(ChatResponseManager.getManagerOnlineSymbol(entity));
            this.textTitle.setText(entity == null ? "" : entity.getName());
            this.textDescription.setVisibility(8);
        }
        Views.setVisibility((View)this.imageLeft, !expand, 4);
    }

    @Override
    public void onTextColorChange(int textColor) {
        this.textTitle.setTextColor(textColor);
        this.textDescription.setTextColor(textColor);
        this.imageRight.setImageResource(textColor == -1 ? R.drawable.ch_plugin_dropdown_arrow_down : R.drawable.ch_plugin_dropdown_arrow_down_b);
    }
}

