package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;

/**
 * Created by mika on 2018. 6. 28..
 */

public class UserChatSelector extends BaseSelector {

  public static int getUserChatCount() {
    int count = 0;
    for (UserChat userChat : Store.getInstance(UserChatStore.class).get()) {
      if (!CompareUtils.exists(userChat.getState(), ChannelIOSelector.getBlockFilters())) {
        count++;
      }
    }

    return count + PushBotSelector.getVisiblePushBotItems().size();
  }

  @Nullable
  public static UserChat get(@Nullable String userChatId) {
    UserChat userChat = Store.getInstance(UserChatStore.class).get(userChatId);
    if (userChat != null && !CompareUtils.exists(userChat.getState(), ChannelIOSelector.getBlockFilters())) {
      return userChat;
    }
    return null;
  }

  public static boolean isEmpty() {
    return getUserChatCount() == 0;
  }
}
