package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.selector.ImageFileSelector;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity
    implements View.OnClickListener, PhotoViewAttacher.OnPhotoTapListener {

  private static final int ANIMATION_DURATION = 200;

  private View layoutOverlay;

  @Nullable
  private String url, filename;
  private boolean menuVisible = true;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_photo_album, Color.BLACK, Color.WHITE);
    layoutOverlay = findViewById(R.id.layout_image);

    String fileId = getIntent().getStringExtra(Const.EXTRA_FILE_ID);

    if (fileId == null) {
      handleError();
      return;
    }

    final List<File> imageFiles = ImageFileSelector.getImageFiles();

    findViewById(R.id.button_close_image).setOnClickListener(this);
    findViewById(R.id.button_link).setOnClickListener(this);
    findViewById(R.id.button_download).setOnClickListener(this);

    PhotoViewPager viewPager = (PhotoViewPager) findViewById(R.id.photo_view_pager);
    PhotoAlbumPagerAdapter adapter = new PhotoAlbumPagerAdapter(this, imageFiles, this);

    viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
      @Override
      public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
      }

      @Override
      public void onPageSelected(int position) {
        File file = imageFiles.get(position);

        url = file.getUrl();
        filename = file.getFilename();
      }

      @Override
      public void onPageScrollStateChanged(int state) {
      }
    });

    viewPager.setAdapter(adapter);
    viewPager.setCurrentItem(imageFiles.indexOf(ImageFileSelector.getImageFile(fileId)));
  }

  private void handleError() {
    UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
    setResult(RESULT_OK);
    finish();
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.button_close_image) {
      finish();
    }
    if (id == R.id.button_link) {
      copyLink();
    }
    if (id == R.id.button_download) {
      download();
    }
  }

  private void copyLink() {
    try {
      ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
      ClipData clip = ClipData.newPlainText("text", url);
      clipboard.setPrimaryClip(clip);

      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
    } catch (Exception ex) {
      UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
    }
  }

  private void download() {
    IntentUtils.setNextActivity(this, DownloadActivity.class)
        .putExtra(Const.EXTRA_URL, url)
        .putExtra(Const.EXTRA_FILE_NAME, filename)
        .putExtra(Const.EXTRA_IMAGE, true)
        .setTransition(Transition.NONE)
        .startActivity();
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    layoutOverlay.animate()
        .alpha(menuVisible ? 0f : 1f)
        .setDuration(ANIMATION_DURATION)
        .setListener(animatorListener).start();
  }

  private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener() {
    @Override
    public void onAnimationStart(Animator animator) {
      menuVisible = !menuVisible;

      if (menuVisible) {
        layoutOverlay.setVisibility(View.VISIBLE);
      }
    }

    @Override
    public void onAnimationEnd(Animator animator) {
      layoutOverlay.setVisibility(menuVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void onAnimationCancel(Animator animator) {
    }

    @Override
    public void onAnimationRepeat(Animator animator) {
    }
  };
}
