package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class InAppPushView extends BasePopupView {

  @Nullable
  private InAppPushItem inAppPushItem;

  public InAppPushView(@NonNull Context context) {
    super(context);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void init(final Context context) {
    super.init(context);

    root.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (inAppPushItem != null) {
          ChannelIO.openChat(context, inAppPushItem.getChatId());
        }

        hide();
      }
    });
  }

  public void show(@NonNull InAppPushItem inAppPushItem) {
    this.inAppPushItem = inAppPushItem;

    super.bindPopupData(inAppPushItem);
    root.setVisibility(VISIBLE);
  }
}
