/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.engine.cache;

import android.annotation.SuppressLint;
import com.zoyi.com.bumptech.glide.load.Key;
import com.zoyi.com.bumptech.glide.load.engine.Resource;
import com.zoyi.com.bumptech.glide.load.engine.cache.MemoryCache;
import com.zoyi.com.bumptech.glide.util.LruCache;

public class LruResourceCache
extends LruCache<Key, Resource<?>>
implements MemoryCache {
    private MemoryCache.ResourceRemovedListener listener;

    public LruResourceCache(int size) {
        super(size);
    }

    @Override
    public void setResourceRemovedListener(MemoryCache.ResourceRemovedListener listener) {
        this.listener = listener;
    }

    @Override
    protected void onItemEvicted(Key key, Resource<?> item) {
        if (this.listener != null) {
            this.listener.onResourceRemoved(item);
        }
    }

    @Override
    protected int getSize(Resource<?> item) {
        return item.getSize();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int level) {
        if (level >= 60) {
            this.clearMemory();
        } else if (level >= 40) {
            this.trimToSize(this.getCurrentSize() / 2);
        }
    }
}

