package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.enumerate.ChannelViewEvent;
import com.zoyi.channel.plugin.android.event.ChannelViewBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.Store;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class InAppPushView extends BasePopupView {

  @Nullable
  private InAppPushItem inAppPushItem;

  public InAppPushView(@NonNull Context context) {
    super(context);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void init(final Context context) {
    super.init(context);

    root.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (inAppPushItem != null) {
          ChannelIO.openChat(context, inAppPushItem.getChatId());
        }

        broadcastHideEvent();
      }
    });

    buttonPopupClose.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        broadcastHideEvent();
      }
    });
  }

  public void show(@Nullable InAppPushItem inAppPushItem) {
    this.inAppPushItem = inAppPushItem;

    if (inAppPushItem != null) {
      super.bindPopupData(inAppPushItem);
      root.setVisibility(VISIBLE);
    }
  }

  // Broadcast to hide all in-app push
  private void broadcastHideEvent() {
    Store.getInstance(InAppPushStore.class).clearData();
    RxBus.post(new ChannelViewBus(ChannelViewEvent.HIDE_IN_APP_PUSH));
  }
}
