/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListUtils {
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        ListUtils.checkNotNull(elements);
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        ListUtils.checkNotNull(elements);
        int capacity = ListUtils.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    private static int computeArrayListCapacity(int arraySize) {
        if (arraySize < 0) {
            throw new IllegalArgumentException();
        }
        long value = 5L + (long)arraySize + (long)(arraySize / 10);
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static <E> boolean hasItems(List<E> list) {
        return list != null && !list.isEmpty();
    }

    @NonNull
    public static <E> List<E> union(@Nullable List<E> list1, @Nullable List<E> list2) {
        ArrayList<E> list = new ArrayList<E>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    @Nullable
    public static <E> E takeFirstPrioirty(@Nullable List<E> list, Comparator<E> comparator) {
        if (list == null || list.size() == 0) {
            return null;
        }
        E target = list.get(0);
        for (E item : list) {
            if (target != null && (item == null || comparator.compare(target, item) >= 0)) continue;
            target = item;
        }
        return target;
    }
}

