package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.Form;
import com.zoyi.channel.plugin.android.model.MessageButton;
import com.zoyi.channel.plugin.android.model.Submit;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.message_format.span.GiantEmojiSpan;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Message implements Entity, PersonEntity {
  private String id;
  private String channelId;
  private String chatType;
  private String chatId;
  private String personType;
  private String personId;
  private String message;
  private String messageV2;
  private String title;
  private Long createdAt;
  private String requestId;
  private File file;
  private WebPage webPage;
  private Log log;
  private SpannableStringBuilder formattedSpanMessage;
  private String formattedStringMessage;
  private List<ProfileBot> profileBot;
  private Form form;
  private Submit submit;
  private String language;
  private String system;
  private List<MessageButton> buttons;

  public Message() {
  }

  public Message(String message, String personType, String personId, long createdAt) {
    this.message = message;
    this.personType = personType;
    this.personId = personId;
    this.createdAt = createdAt;
    this.formattedSpanMessage = ParseUtils.parseMessage(message);
    if (formattedSpanMessage != null) {
      this.formattedStringMessage = formattedSpanMessage.toString();
    }
  }

  @Override
  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getChatType() {
    return chatType;
  }

  public String getChatId() {
    return chatId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  @Override
  public boolean isOwnedBy(@Nullable String personType, @Nullable String personId) {
    return personType != null && personType.equals(this.personType) && personId != null && personId.equals(this.personId);
  }

  public String getMessage() {
    if (messageV2 != null) {
      return messageV2;
    } else {
      return message;
    }
  }

  @NonNull
  public Long getCreatedAt() {
    if (createdAt == null) {
      return TimeUtils.getCurrentTime();
    }
    return createdAt;
  }

  public String getTitle() {
    return title;
  }

  public String getRequestId() {
    return requestId;
  }

  public File getFile() {
    return file;
  }

  public WebPage getWebPage() {
    return webPage;
  }

  public boolean hasContent() {
    return file != null || webPage != null;
  }

  public final static String CLASSNAME = "Message";

  public boolean isUserMessage() {
    return "User".equals(personType) || "Veil".equals(personType);
  }

  public Log getLog() {
    return log;
  }

  public SpannableStringBuilder getFormattedSpanMessage() {
    return formattedSpanMessage;
  }

  public String getFormattedStringMessage() {
    return formattedStringMessage;
  }

  public List<ProfileBot> getProfileBot() {
    return profileBot;
  }

  public Form getForm() {
    return form;
  }

  public Submit getSubmit() {
    return submit;
  }

  public String getLanguage() {
    return language;
  }

  public List<MessageButton> getButtons() {
    return buttons;
  }

  public void setFormattedSpanMessage(SpannableStringBuilder formattedSpanMessage) {
    this.formattedSpanMessage = formattedSpanMessage;
  }

  public void setFormattedStringMessage(String formattedStringMessage) {
    this.formattedStringMessage = formattedStringMessage;
  }

  public void clearForm() {
    this.form = null;
  }

  public boolean hasOnlyEmoji() {
    return formattedSpanMessage != null
        && formattedSpanMessage.length() > 0
        && formattedSpanMessage.getSpans(0, formattedSpanMessage.length(), GiantEmojiSpan.class).length > 0;
  }

  public boolean shouldTranslate() {
    Context context = ChannelIO.getAppContext();

    return message != null
        && context != null
        && language != null
        && !Utils.isSameLanguage(language)
        && PrefSupervisor.canTranslateMessage(context);
  }

  public boolean hasImageRedirectUrl() {
    return file != null && file.getImageRedirectUrl() != null;
  }

  public boolean hasButtons() {
    return ListUtils.hasItems(buttons);
  }

  public String getSystem() {
    return system;
  }

  public static Comparator<Message> getMaxComparator() {
    return new Comparator<Message>() {
      @Override
      public int compare(Message o1, Message o2) {
        return CompareUtils.compare(o1.createdAt, o2.createdAt);
      }
    };
  }

  public static Comparator<Message> getMinComparator() {
    return new Comparator<Message>() {
      @Override
      public int compare(Message o1, Message o2) {
        return CompareUtils.compare(o2.createdAt, o1.createdAt);
      }
    };
  }
}
