/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.holder.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItemType;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.PushBotChatItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.PushBotSelector;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UserChatListAdapter
extends RecyclerView.Adapter<UserChatHolder>
implements UserChatAdapterContract.View,
UserChatAdapterContract.Model {
    @Nullable
    private OnUserChatClickListener listener;
    @NonNull
    private Map<String, ChatListItem> userChatItems = new HashMap<String, ChatListItem>();
    @NonNull
    private SortedList<ChatListItem> items = new SortedList(ChatListItem.class, new SortedListCallback(this, true));

    UserChatListAdapter() {
    }

    @Override
    public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
        this.listener = clickListener;
    }

    @Override
    public void setUserChats(List<UserChat> userChats) {
        this.clear();
        this.items.beginBatchedUpdates();
        for (UserChat userChat : userChats) {
            if (!this.canUpsertUserChat(userChat)) continue;
            this.addNewChatListItem(new UserChatItem(userChat));
        }
        this.addLocalChats();
        this.items.endBatchedUpdates();
    }

    public void clear() {
        this.userChatItems.clear();
        this.items.clear();
    }

    public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return UserChatHolder.newInstance(parent, this.listener);
    }

    public void onBindViewHolder(UserChatHolder holder, int position) {
        ChatListItem chatListItem = (ChatListItem)this.items.get(position);
        if (chatListItem != null) {
            holder.setChatListItem(chatListItem);
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public void updateManager(String managerId) {
        for (int i = 0; i < this.items.size(); ++i) {
            UserChatItem item;
            if (!(this.items.get(i) instanceof UserChatItem) || !CompareUtils.isSame((item = (UserChatItem)this.items.get(i)).getHostType(), "Manager") || !CompareUtils.isSame(item.getHostId(), managerId)) continue;
            this.items.updateItemAt(i, (Object)item);
        }
    }

    @Override
    public void updateSession(@NonNull Session session) {
        this.upsertUserChat(UserChatSelector.get(session.getChatId()));
    }

    @Override
    public void upsertPushBotItem(@NonNull PushBotItem pushBotItem) {
        PushBotChatItem pushBotChatItem = new PushBotChatItem(pushBotItem);
        int position = this.items.indexOf((Object)pushBotChatItem);
        if (position >= 0) {
            this.items.updateItemAt(position, (Object)pushBotChatItem);
        } else {
            this.items.add((Object)pushBotChatItem);
        }
    }

    @Override
    public void removePushBotItem(@NonNull PushBotItem pushBotItem) {
        this.items.remove((Object)new PushBotChatItem(pushBotItem));
    }

    @Override
    public void upsertUserChat(@Nullable UserChat userChat) {
        if (this.canUpsertUserChat(userChat) && userChat != null) {
            ChatListItem oldUserChatItem = this.userChatItems.get(userChat.getId());
            UserChatItem newUserChatItem = new UserChatItem(userChat);
            if (oldUserChatItem != null) {
                this.updateUserChatItem(oldUserChatItem, newUserChatItem);
            } else {
                this.addNewChatListItem(newUserChatItem);
            }
        }
    }

    @Override
    public void removeUserChat(@NonNull String chatId) {
        if (this.userChatItems.containsKey(chatId)) {
            this.items.remove((Object)this.userChatItems.get(chatId));
            this.userChatItems.remove(chatId);
        }
    }

    private boolean canUpsertUserChat(@Nullable UserChat userChat) {
        return userChat != null && userChat.getId() != null && (!userChat.isStateReady() || userChat.getLastMessageId() != null);
    }

    private void updateUserChatItem(@NonNull ChatListItem oldChatListItem, @NonNull ChatListItem newChatListItem) {
        int position = this.items.indexOf((Object)oldChatListItem);
        if (position >= 0) {
            if (newChatListItem.getItemType() == ChatListItemType.USER_CHAT) {
                this.userChatItems.put(newChatListItem.getId(), newChatListItem);
            }
            this.items.updateItemAt(position, (Object)newChatListItem);
        }
    }

    private void addNewChatListItem(@NonNull ChatListItem chatListItem) {
        if (chatListItem.getItemType() == ChatListItemType.USER_CHAT) {
            this.userChatItems.put(chatListItem.getId(), chatListItem);
        }
        this.items.add((Object)chatListItem);
    }

    private void addLocalChats() {
        List<PushBotItem> pushBotItems = PushBotSelector.getVisiblePushBotItems();
        for (PushBotItem pushBotItem : pushBotItems) {
            this.addNewChatListItem(new PushBotChatItem(pushBotItem));
        }
    }

    @Override
    @Nullable
    public ChatListItem getFirstChatListItem() {
        if (this.items.size() >= 1) {
            return (ChatListItem)this.items.get(0);
        }
        return null;
    }

    @Override
    @Nullable
    public ChatListItem getUserChatItem(@NonNull String id2) {
        return this.userChatItems.get(id2);
    }
}

