/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.overlayheader;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.view.handler.OnSizeChangeListener;

public class SizeObservableFrameLayout
extends FrameLayout {
    @Nullable
    private OnSizeChangeListener sizeChangeListener;
    @Nullable
    private View.OnTouchListener touchListener;
    private int height = 0;

    public SizeObservableFrameLayout(@NonNull Context context) {
        super(context);
    }

    public SizeObservableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SizeObservableFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onSizeChanged(final int w, final int h, final int oldw, final int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (h != this.height) {
            this.height = h;
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (SizeObservableFrameLayout.this.sizeChangeListener != null) {
                        SizeObservableFrameLayout.this.sizeChangeListener.onSizeChange(w, h, oldw, oldh);
                    }
                }
            }, 1L);
        }
    }

    public int getLastHeight() {
        return this.height;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.touchListener != null) {
            return this.touchListener.onTouch(this.getRootView(), event);
        }
        return false;
    }

    public void setOnSizeChangeListener(@Nullable OnSizeChangeListener listener) {
        this.sizeChangeListener = listener;
    }
}

