package com.zoyi.channel.plugin.android.util.message_format;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.message_format.message.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class MessageParser {

  private final String ESCAPE_SEQUENCE = "```";

  private List<MessagePattern> patterns;
  private int linkColor;

  @Nullable
  public static MessageParser get() {
    if (ChannelIO.getAppContext() == null) {
      return null;
    }
    return LazyMessageParser.INSTANCE;
  }

  // Don't use this method except running test code
  public static MessageParser get(Context context) {
    return new MessageParser(context);
  }

  private static class LazyMessageParser {
    private static final MessageParser INSTANCE = new MessageParser(ChannelIO.getAppContext());
  }

  private MessageParser(@Nullable Context context) {
    this.patterns = new ArrayList<>();
    this.linkColor = context != null
        ? ContextCompat.getColor(context, R.color.ch_cobalt)
        : Color.parseColor("#00a6ff");

    /**
     * 패턴을 추가한 순서대로 파싱 필터를 적용하므로
     * 특별한 이유없이 순서를 바꾸지 말 것
     */
    patterns.add(new EscapeMessage());
    patterns.add(new BoldMessage());
    patterns.add(new ItalicMessage());
    patterns.add(new MentionMessage());
    if (context != null) {
      patterns.add(new EmojiMessage(context));
    }
    patterns.add(new LinkMessage(linkColor));
    patterns.add(new UnescapeMessage());
    patterns.add(new GiantEmojiMessage());
  }

  @NonNull
  public SpannableStringBuilder parse(@Nullable String message) {
    SpannableStringBuilder resultMessage = new SpannableStringBuilder();

    if (message == null) {
      return resultMessage;
    }

    String[] tokens = message.split(ESCAPE_SEQUENCE, -1);
    
    for (int index = 0; index < tokens.length; index++) {
      SpannableStringBuilder parsedToken = parseString(tokens[index]);

      if (index % 2 == 0) {
        resultMessage.append(parsedToken);
      } else if (index == tokens.length - 1) {
        resultMessage.append(ESCAPE_SEQUENCE);
        resultMessage.append(parsedToken);
      } else {
        resultMessage.append(tokens[index]);
      }
    }

    return resultMessage;
  }

  public SpannableStringBuilder parseString(String message) {
    SpannableStringBuilder spannableString = new SpannableStringBuilder(message);
    for (MessagePattern messagePattern : patterns) {
      spannableString = messagePattern.parse(spannableString);
    }

    return spannableString;
  }
}
