package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.Manager;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by mika on 2018. 6. 18..
 */

public class ManagerStore extends CollectionStore<Manager> implements DestroyableStore {

  private Set<String> followingManagerIds;

  public Set<String> getFollowingManagerIds() {
    return followingManagerIds;
  }

  public void setFollowingManagers(List<Manager> managers) {
    if (managers != null) {
      followingManagerIds = new HashSet<>();
      for (Manager manager : managers) {
        if (manager != null) {
          followingManagerIds.add(manager.getId());
        }
      }
    }
  }

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.MANAGER;
  }

  @Override
  public void clearData() {
    map.clear();

    if (followingManagerIds != null) {
      followingManagerIds.clear();
      followingManagerIds = null;
    }
  }
}
