/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.internal.operators.DeferredScalarSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeReduceSeed<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> source;
    final R initialValue;
    final Func2<R, ? super T, R> reducer;

    public OnSubscribeReduceSeed(Observable<T> source, R initialValue, Func2<R, ? super T, R> reducer) {
        this.source = source;
        this.initialValue = initialValue;
        this.reducer = reducer;
    }

    @Override
    public void call(Subscriber<? super R> t) {
        new ReduceSeedSubscriber<T, R>(t, this.initialValue, this.reducer).subscribeTo(this.source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReduceSeedSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        final Func2<R, ? super T, R> reducer;

        public ReduceSeedSubscriber(Subscriber<? super R> actual, R initialValue, Func2<R, ? super T, R> reducer) {
            super(actual);
            this.value = initialValue;
            this.hasValue = true;
            this.reducer = reducer;
        }

        @Override
        public void onNext(T t) {
            try {
                this.value = this.reducer.call(this.value, t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.actual.onError(ex);
            }
        }
    }
}

