package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class PushBotPopupView extends BasePopupView {

  private static final String BUTTON = "button";
  private static final String IMAGE = "image";
  private static final int MAX_PUSH_BOT_IMAGE_HEIGHT = 220;

  private ViewGroup layoutPushBotPopupImage;
  private ImageView imagePushBotPopupImage;
  private MaskableFrameLayout layoutPushBotPopupButton;
  private TextView textPushBotPopupButton;

  @Nullable
  private OnPushBotClickListener onPushBotClickListener;

  @Nullable
  private PushBotItem pushBotItem;

  public PushBotPopupView(@NonNull Context context) {
    super(context);
  }

  public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void init(final Context context) {
    super.init(context);

    layoutPushBotPopupImage = root.findViewById(R.id.ch_layout_popup_image);
    imagePushBotPopupImage = root.findViewById(R.id.ch_image_popup_image);
    layoutPushBotPopupButton = root.findViewById(R.id.ch_layout_popup_button);
    textPushBotPopupButton = root.findViewById(R.id.ch_text_popup_button);

    root.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (pushBotItem != null && onPushBotClickListener != null) {
          onPushBotClickListener.onPushBotClick(pushBotItem.getId());
        }
        hide();
      }
    });

    layoutPushBotPopupImage.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (pushBotItem != null && onPushBotClickListener != null) {
          onPushBotClickListener.onPushBotContentsClick(pushBotItem.getId(), pushBotItem.getImageRedirectUrl());
        }
        hide();
      }
    });

    layoutPushBotPopupButton.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        if (pushBotItem != null && onPushBotClickListener != null) {
          onPushBotClickListener.onPushBotContentsClick(pushBotItem.getId(), pushBotItem.getButtonRedirectUrl());
        }
        hide();
      }
    });
  }

  public void setPushBotClickListener(OnPushBotClickListener onPushBotClickListener) {
    this.onPushBotClickListener = onPushBotClickListener;
  }

  public void show(@NonNull PushBotItem pushBotItem) {
    this.pushBotItem = pushBotItem;

    super.bindPopupData(pushBotItem);
    bindPushBotItem(pushBotItem);

    root.setVisibility(VISIBLE);
  }

  private void bindPushBotItem(@NonNull PushBotItem pushBotItem) {

    // Set button or image
    if (pushBotItem.getAttachment() != null) {

      switch (pushBotItem.getAttachment()) {
        case BUTTON:
          if (pushBotItem.getButtonTitle() != null) {
            textPushBotPopupButton.setBackgroundColor(ColorSelector.getBackgroundColor());
            textPushBotPopupButton.setText(pushBotItem.getButtonTitle());

            layoutPushBotPopupButton.setVisibility(VISIBLE);
          }
          break;

        case IMAGE:
          PreviewThumb imagePreview = pushBotItem.getImageThumb();
          if (imagePreview != null && imagePreview.getUrl() != null) {

            // Resize push bot image
            if (imagePreview.getHeight() > MAX_PUSH_BOT_IMAGE_HEIGHT) {
              ViewGroup.LayoutParams layoutParams = imagePushBotPopupImage.getLayoutParams();
              layoutParams.height = (int) Utils.dpToPx(MAX_PUSH_BOT_IMAGE_HEIGHT);
              imagePushBotPopupImage.setLayoutParams(layoutParams);
            }

            Glide.with(context)
                .load(imagePreview.getUrl())
                .centerCrop()
                .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                .into(imagePushBotPopupImage);

            layoutPushBotPopupImage.setVisibility(VISIBLE);
          }
          break;
      }
    }
  }
}
