package com.zoyi.channel.plugin.android.evaluation;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.util.DeviceUtils;

import java.util.HashMap;
import java.util.Map;

import static com.zoyi.channel.plugin.android.evaluation.TargetKey.CITY;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.COUNTRY;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.DEVICE;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.DEVICE_CATEGORY;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_CREATED_AT;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_ID;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_MOBILE_NUMBER;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_NAME;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_PROFILE;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_SEGMENT;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_TYPE;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.GUEST_UPDATED_AT;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.LOCALE;
import static com.zoyi.channel.plugin.android.evaluation.TargetKey.OS;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class EnvironmentInfo {

  private Map<String, Object> info;

  public static EnvironmentInfo newInstance() {
    return new EnvironmentInfo();
  }

  private EnvironmentInfo() {
    this.info = new HashMap<String, Object>() {{
      put(OS, DeviceUtils.getOs());
      put(DEVICE, Build.MODEL);
      put(DEVICE_CATEGORY, Const.DEVICE_TYPE_MOBILE);
      put(LOCALE, PrefSupervisor.getPluginLanguage(ChannelIO.getAppContext()));
      put(COUNTRY, GuestSelector.getCountry());
      put(CITY, GuestSelector.getCity());
      put(GUEST_ID, GuestSelector.getId());
      put(GUEST_TYPE, GuestSelector.getPersonType());
      put(GUEST_CREATED_AT, GuestSelector.getCreatedAt());
      put(GUEST_UPDATED_AT, GuestSelector.getUpdatedAt());
      put(GUEST_MOBILE_NUMBER, GuestSelector.getMobileNumber());
      put(GUEST_NAME, GuestSelector.getName());
      put(GUEST_SEGMENT, GuestSelector.getSegment());
      put(GUEST_PROFILE, GuestSelector.getProfile());
    }};
  }

  public EnvironmentInfo put(@NonNull String key, @Nullable Object value) {
    if (value != null) {
      info.put(key, value);
    }
    return this;
  }

  @Nullable
  public Object getValueByKey(@NonNull String key) throws Exception {
    return info.get(key);
  }

  @Nullable
  @SuppressWarnings("unchecked")
  public Object getValueBySubKey(@NonNull String key, @NonNull String subKey) throws Exception {
    Map<String, Object> subInfo = (Map<String, Object>) info.get(key);

    if (subInfo != null) {
      return subInfo.get(subKey);
    } else {
      return null;
    }
  }
}
