/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnImageMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TextMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

public class ImageMessageHolder
extends TextMessageHolder {
    private Context context;
    protected MaskableFrameLayout imageLayout;
    protected ImageView imagePlaceholder;
    protected ImageView imageContent;
    @Nullable
    private Message message;
    private Point previewImageSize;
    @Nullable
    private OnImageMessageClickListener listener;

    public static ImageMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnImageMessageClickListener listener) {
        return new ImageMessageHolder(ImageMessageHolder.getItemView(parent, messageType), messageType, listener);
    }

    public ImageMessageHolder(View itemView, MessageType messageType, @Nullable OnImageMessageClickListener listener) {
        super(itemView, messageType, listener);
        this.context = itemView.getContext();
        this.listener = listener;
        this.imageLayout = (MaskableFrameLayout)itemView.findViewById(R.id.ch_message_content_image);
        this.imagePlaceholder = (ImageView)itemView.findViewById(R.id.image_placeholder);
        this.imageContent = (ImageView)itemView.findViewById(R.id.image_chat);
        this.imageContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageMessageHolder.this.onImageClick();
            }
        });
        this.previewImageSize = new Point();
    }

    @Override
    public void bind(ChatMessageItem item, boolean isConnectedMessage) {
        File file;
        super.bind(item, isConnectedMessage);
        this.message = item.getMessage();
        if (this.message != null && (file = this.message.getFile()) != null) {
            this.setImageMessage(file.getPreviewThumb(), false, this.message.getMessage());
        }
    }

    protected void setImageMessage(PreviewThumb preview, boolean isWebPage, String message) {
        Point windowSize = Utils.getWindowSize(this.context);
        if (isWebPage) {
            int width = windowSize.x - (int)Utils.dpToPx(this.context, 115.0f);
            int height = (int)((double)width * 0.52);
            this.previewImageSize.set(width, height);
        } else {
            this.previewImageSize = Utils.resizeImage(this.context, new Point(preview.getWidth().intValue(), preview.getHeight().intValue()));
        }
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.imageLayout.getLayoutParams();
        params.width = this.previewImageSize.x;
        params.height = this.previewImageSize.y;
        int marginTop = (int)Utils.dpToPx(this.context, 8.0f);
        params.setMargins(0, marginTop, 0, 0);
        this.imageLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.imageLayout.setVisibility(0);
        this.imagePlaceholder.setVisibility(0);
        Glide.with((Context)this.itemView.getContext()).load(preview.getUrl()).diskCacheStrategy(DiskCacheStrategy.SOURCE).override(this.previewImageSize.x, this.previewImageSize.y).centerCrop().listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                ImageMessageHolder.this.imagePlaceholder.setVisibility(8);
                return false;
            }
        }).into(this.imageContent);
    }

    protected Point getPreviewImageSize() {
        return this.previewImageSize;
    }

    protected void onImageClick() {
        if (this.listener != null && this.message != null) {
            this.listener.onImageClick(this.message.getFile());
        }
    }
}

