/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIOManager;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.socket.SocketManager;

public class ActivityLifecycleManager
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private Activity topActivity;
    private int running = 0;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        FrameLayout root;
        if (!(activity instanceof BaseActivity) && (root = (FrameLayout)activity.findViewById(R.id.channel_io_view)) == null) {
            root = new FrameLayout((Context)activity);
            root.setId(R.id.channel_io_view);
            root.addView((View)new ChannelView((Context)activity));
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        this.topActivity = activity;
        if (++this.running == 1) {
            RxBus.post(new CommandBus(Command.APP_STARTED));
            SocketManager.connect();
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (this.topActivity == activity) {
            this.topActivity = null;
        }
        if (--this.running == 0) {
            SocketManager.disconnect();
            RxBus.post(new CommandBus(Command.APP_STOPPED));
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (activity instanceof UserChatListActivity) {
            for (ChannelPluginListener l : ChannelIOManager.getChannelPluginListeners()) {
                if (l == null) continue;
                l.willHideMessenger();
            }
        }
    }

    @Nullable
    Activity getTopActivity() {
        return this.topActivity;
    }

    public void finish(boolean animated) {
        if (this.topActivity != null && this.topActivity instanceof BaseActivity) {
            this.topActivity.setResult(21);
            ((BaseActivity)this.topActivity).finish(animated);
        }
    }
}

