package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnFileMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnImageMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnTextMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.model.rest.Message;

import java.util.Collection;
import java.util.List;

public interface ChatAdapterContract {

  interface View {

    void setOnTextMessageClickListener(OnTextMessageClickListener onTextMessageClickListener);
    void setOnFileMessageClickListener(OnFileMessageClickListener onFileMessageClickListener);
    void setOnImageMessageClickListener(OnImageMessageClickListener onImageMessageClickListener);
    void setOnWebMessageClickListener(OnWebMessageClickListener onWebMessageClickListener);
    void setOnSendingMessageClickListener(OnSendingMessageClickListener onSendingMessageClickListener);
    void setOnProfileUpdateListener(OnProfileUpdateListener onProfileUpdateListener);
    void setOnFormMessageClickListener(OnFormMessageClickListener onFormMessageClickListener);
  }

  interface Model {

    void addMessage(Message message, @Nullable String chatId);
    void addMessages(@Nullable List<Message> messages, @Nullable String chatId);

    void addMessageItem(MessageItem item);
    void addMessageItems(Collection<MessageItem> items);
    void removeMessageItem(MessageItem item);
    void addOrUpdateMessageItem(int position, MessageItem item);

    int getIndex(MessageItem item);
    @Nullable
    MessageItem getItem(int index);
    @Nullable
    String getLastMessageItemId();
    @Nullable
    WelcomeMessageItem getWelcomeMessage();

    void setImageFilesToStorage();
    void setWelcomeMessage(String message, Long timestamp);
  }
}
