/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list.holder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

public class UserChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private Context context;
    private AvatarLayout avatar;
    private CHTextView textName;
    private CHTextView textMessage;
    private CHTextView textTime;
    private CHTextView textBadge;
    private UserChatItem item;
    @Nullable
    private OnUserChatClickListener listener;

    public static UserChatHolder newInstance(ViewGroup parent, @Nullable OnUserChatClickListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View itemView = inflater.inflate(R.layout.ch_plugin_item_user_chat, parent, false);
        return new UserChatHolder(itemView, listener);
    }

    public UserChatHolder(View itemView, @Nullable OnUserChatClickListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.listener = listener;
        this.avatar = (AvatarLayout)itemView.findViewById(R.id.avatar_single);
        this.avatar.setTextSize(16);
        this.textName = (CHTextView)itemView.findViewById(R.id.text_name);
        this.textMessage = (CHTextView)itemView.findViewById(R.id.text_message);
        this.textTime = (CHTextView)itemView.findViewById(R.id.text_time);
        this.textBadge = (CHTextView)itemView.findViewById(R.id.text_badge);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    @Initializer
    public void setUserChatItem(UserChatItem item) {
        this.item = item;
        ProfileEntity profileEntity = item.getProfile();
        String hostName = item.getHostName(this.context);
        String alert = item.getAlert();
        this.avatar.set(profileEntity);
        this.textName.setText(hostName);
        this.textTime.setText(item.getUpdatedDate());
        Views.setVisibility((View)this.textBadge, !TextUtils.isEmpty((CharSequence)alert), 4);
        this.textBadge.setText(alert);
        this.setTextMessage();
    }

    private void setTextMessage() {
        UserChat userChat = this.item.getUserChat();
        Message message = this.item.getLastMessage();
        if (userChat != null && userChat.getReview() != null) {
            this.textMessage.setTextByKey("ch.review.complete.preview", R.color.ch_light);
        } else if (message != null) {
            if (message.getMessage() != null) {
                if (userChat != null && userChat.isStateClosed()) {
                    this.textMessage.setText(message.getFormattedStringMessage(), R.color.ch_light);
                } else {
                    this.textMessage.setText(message.getFormattedStringMessage(), R.color.ch_dark);
                }
            } else if (message.getFile() != null) {
                if (message.getFile().isImage()) {
                    this.textMessage.setTextByKey("ch.notification.upload_image.description", R.color.ch_dark);
                } else {
                    this.textMessage.setTextByKey("ch.notification.upload_file.description", R.color.ch_dark);
                }
            } else {
                this.textMessage.setText("");
            }
        } else {
            this.textMessage.setText("");
        }
    }

    @Nullable
    public String getChatId() {
        if (this.item != null) {
            return this.item.getId();
        }
        return null;
    }

    public void onClick(View view) {
        if (this.listener != null && this.getChatId() != null) {
            this.listener.onUserChatClick(this.getChatId());
        }
    }

    public boolean onLongClick(View v) {
        if (this.listener != null && this.getChatId() != null) {
            this.listener.onUserChatLongClick(this.getChatId());
        }
        return true;
    }
}

