package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TokenStore;
import com.zoyi.channel.plugin.android.store.VeilStore;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2018. 8. 24..
 */

public class TokenInterceptor implements Interceptor {

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();
    Response response = chain.proceed(request);

    String jwt = response.header(Const.X_GUEST_JWT);
    if (jwt != null) {
      Store.getInstance(TokenStore.class).setJwt(jwt);
    }

    String veilId = response.header(Const.X_VEIL_ID);
    if (veilId != null) {
      Store.getInstance(VeilStore.class).setVeilId(veilId);
      PrefSupervisor.setVeilId(ChannelIO.getAppContext(), veilId);
    }

    return response;
  }
}
