/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

public class WatchedEditText
extends AppCompatEditText {
    private Context context;
    @Nullable
    private Button button;
    @Nullable
    private EditTextChangedListener listener;
    private Subscription subscription;
    @Nullable
    private String hintTextKey;
    private boolean block = false;
    private int activeColor;
    private int deactiveColor;

    public WatchedEditText(Context context) {
        super(context);
        this.init(context, null);
    }

    public WatchedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        this.subscribe();
        this.setTypeArray(attrs);
    }

    private void setTypeArray(@Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
            this.hintTextKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_hint_key);
            this.setHintByKey(this.hintTextKey);
        }
    }

    private void subscribe() {
        this.subscription = RxBus.observable().subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                WatchedEditText.this.onReceiveEvent(o);
            }
        });
    }

    private void onReceiveEvent(Object object) {
        if (object instanceof LanguageBus && this.hintTextKey != null) {
            super.setHint((CharSequence)ResUtils.getString(this.context, this.hintTextKey));
        }
    }

    public void setHintByKey(@Nullable String key) {
        if (this.hintTextKey != null) {
            this.hintTextKey = key;
            super.setHint((CharSequence)ResUtils.getString(this.context, key));
        }
    }

    public void setWatchedTextChangedListener(EditTextChangedListener listener) {
        this.listener = listener;
        this.listener.onWatchedTextChanged(this.getText().toString());
    }

    public void setHandledButton(Button button, int activeColor, int deactiveColor) {
        this.button = button;
        this.activeColor = activeColor;
        this.deactiveColor = deactiveColor;
        this.setButtonStyle(this.getString());
    }

    protected void onSelectionChanged(int start, int end) {
        super.onSelectionChanged(start, end);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.listener != null && !this.block) {
            this.listener.onWatchedTextChanged(text.toString());
        }
        this.setButtonStyle(text.toString());
    }

    private void setButtonStyle(String text) {
        if (this.button != null) {
            if ("".equals(StringUtils.stripEnd(text, null))) {
                this.button.setEnabled(false);
                this.button.setTextColor(this.deactiveColor);
            } else {
                this.button.setEnabled(true);
                this.button.setTextColor(this.activeColor);
            }
        }
    }

    public void setTextWithBlock(String text) {
        this.block = true;
        this.setText(text);
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public String getString() {
        return this.getText().toString();
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getString());
    }

    protected void onDetachedFromWindow() {
        if (!this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        super.onDetachedFromWindow();
    }
}

