/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.StoreBus;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.store.Store;

public abstract class SingleStore<E extends Entity>
extends Store {
    protected E data;

    public synchronized E get() {
        return this.data;
    }

    public synchronized void set(E e) {
        this.data = e;
        if (e != null) {
            RxBus.post(new StoreBus<E>(this.getStoreType(), UpdateType.UPDATE, e));
        }
    }

    public synchronized void update(E e) {
        if (e != null && this.canUpdate(e)) {
            this.data = e;
            RxBus.post(new StoreBus<E>(this.getStoreType(), UpdateType.UPDATE, e));
        }
    }

    protected boolean canUpdate(E e) {
        return this.data != null && e != null && this.data.getId() != null && this.data.getId().equals(e.getId());
    }

    public synchronized boolean isExists() {
        return this.data != null;
    }

    @Override
    public void clearData() {
        this.data = null;
    }
}

