/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Cancellable;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CancellableSubscription
extends AtomicReference<Cancellable>
implements Subscription {
    private static final long serialVersionUID = 5718521705281392066L;

    public CancellableSubscription(Cancellable cancellable) {
        super(cancellable);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.get() == null;
    }

    @Override
    public void unsubscribe() {
        Cancellable c;
        if (this.get() != null && (c = (Cancellable)this.getAndSet(null)) != null) {
            try {
                c.cancel();
            }
            catch (Exception ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaHooks.onError(ex);
            }
        }
    }
}

