/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.enumerate.UserChatListState;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

public class UserChatPresenter
implements UserChatContract.Presenter,
OnUserChatClickListener {
    private UserChatContract.View view;
    private UserChatAdapterContract.View adapterView;
    private UserChatAdapterContract.Model adapterModel;
    private Context context;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;
    private boolean init = true;

    public UserChatPresenter(Context context) {
        this.context = context;
    }

    @Override
    @Initializer
    public void setView(UserChatContract.View view) {
        this.view = view;
    }

    @Override
    @Initializer
    public void setAdapterView(UserChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnUserChatClickListener(this);
    }

    @Override
    @Initializer
    public void setAdapterModel(UserChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                if (SocketManager.isReady()) {
                    this.getUserChats();
                    break;
                }
                SocketManager.connect();
                break;
            }
            case READY: 
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void redrawList() {
        this.adapterView.notifyDataSetChanged();
    }

    private void setState(UserChatListState state) {
        this.state = state;
    }

    private boolean canUpdate() {
        return UserChatListState.READY.equals((Object)this.state);
    }

    private void getUserChats() {
        this.view.setErrorView(false);
        if (SocketManager.isReady()) {
            this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
            this.setState(UserChatListState.USER_CHAT_LIST_LOADING);
            this.fetchUserChats();
        } else {
            this.setState(UserChatListState.WAITING_SOCKET);
            SocketManager.reconnect();
        }
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        switch (command) {
            case READY: {
                this.view.setErrorView(false);
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    break;
                }
                this.refresh();
                break;
            }
            case SOCKET_DISCONNECTED: {
                boolean force;
                this.setState(UserChatListState.WAITING_SOCKET);
                Store.getInstance(UserChatStore.class).setCanUpdate(false);
                if (object == null || !(object instanceof Boolean) || (force = ((Boolean)object).booleanValue())) break;
                this.view.setErrorView(true);
                break;
            }
            case SOCKET_ERROR: {
                this.setState(UserChatListState.WAITING_SOCKET);
                Store.getInstance(UserChatStore.class).setCanUpdate(false);
                this.view.setErrorView(true);
            }
        }
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        if (entity != null && this.canUpdate()) {
            if (entity instanceof Session) {
                this.adapterModel.updateSession((Session)entity);
            } else if (entity instanceof Manager) {
                this.adapterModel.updateManager(entity.getId());
            }
        }
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        if (entity != null && this.canUpdate()) {
            block0 : switch (storeType) {
                case USER_CHAT: {
                    UserChat userChat = (UserChat)entity;
                    switch (updateType) {
                        case DELETE: {
                            this.adapterModel.removeUserChat(userChat);
                            break block0;
                        }
                        case UPDATE: {
                            this.adapterModel.upsertUserChat(userChat);
                        }
                    }
                }
            }
        }
    }

    private void fetchUserChats() {
        ChannelIO.getApi().getUserChats("updatedAt", "DESC", 50, UserChatSelector.getStateFilters()).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatPresenter.this.init = false;
                UserChatPresenter.this.view.hideProgress();
                UserChatPresenter.this.handleError();
            }

            @Override
            public void onNext(UserChatsWrapper repo) {
                UserChatPresenter.this.view.hideProgress();
                if (repo != null) {
                    repo.set();
                    UserChatPresenter.this.setState(UserChatListState.READY);
                    UserChatPresenter.this.adapterModel.init(repo);
                    UserChatPresenter.this.view.userChatsFetched(repo, UserChatPresenter.this.init);
                    UserChatPresenter.this.init = false;
                } else {
                    UserChatPresenter.this.handleError();
                }
            }
        });
    }

    public void handleError() {
        if (UserChatListState.USER_CHAT_LIST_LOADING.equals((Object)this.state)) {
            this.setState(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
            this.view.setErrorView(true);
        }
    }

    @Override
    public void removeUserChat(final String chatId) {
        this.view.showProgress(ResUtils.getString(this.context, "ch.chat.delete_progress"));
        ChannelIO.getApi().removeUserChat(chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<Void>(){

            @Override
            public void onError(RetrofitException error) {
            }

            @Override
            public void onNext(Void aVoid) {
                UserChatPresenter.this.adapterView.removeUserChat(chatId);
                UserChatPresenter.this.view.completeRemoveChat();
            }
        });
    }

    @Override
    public void onUserChatClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.view.startChat(chatId);
        }
    }

    @Override
    public void onUserChatLongClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.view.showDeleteUserChatDialog(chatId);
        }
    }
}

