package com.zoyi.channel.plugin.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.event.LanguageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;

public class CHSwitchView extends SwitchCompat{
  private Context context;

  @Nullable
  private String textKey;
  private Subscription subscription;

  public CHSwitchView(Context context) {
    super(context);
    init(context, null);
  }

  public CHSwitchView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);

  }

  public CHSwitchView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;
    subscribe();
    setTypeArray(attrs);
  }

  private void setTypeArray(@Nullable AttributeSet attrs) {
    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
      textKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_key);
      setTextByKey(textKey);
    }
  }

  private void subscribe() {
    subscription = RxBus.observable().subscribe(new Action1<Object>() {
          @Override
          public void call(Object o) {
            onReceiveEvent(o);
          }
        });
  }

  private void onReceiveEvent(Object object) {
    if (object instanceof LanguageBus && textKey != null) {
      setTextByKey(textKey);
    }
  }

  public void setTextByKey(String key) {
    if (key != null) {
      this.textKey = key;
      super.setText(ResUtils.getString(context, key));
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    if (!subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    super.onDetachedFromWindow();
  }
}
