/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ManagersWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.Field;
import com.zoyi.retrofit2.http.FormUrlEncoded;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.rx.Observable;
import java.util.Map;

public interface ChannelApi {
    @GET(value="packages/{packageId}/versions/latest")
    public Observable<PackageWrapper> getLastestPackage(@Path(value="packageId") String var1, @Query(value="from") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/plugins/{key}/boot/v2")
    public Observable<PluginWrapper> bootV2(@HeaderMap Map<String, String> var1, @Path(value="key") String var2, @Body RequestBody var3);

    @GET(value="/app/plugins/{pluginId}")
    public Observable<PluginWrapper> getPlugin(@Path(value="pluginId") String var1);

    @POST(value="/app/guests/touch")
    public Observable<GuestWrapper> touch();

    @GET(value="/app/user_chats")
    public Observable<UserChatsWrapper> getUserChats(@Query(value="sortField") String var1, @Query(value="sortOrder") String var2, @Query(value="limit") Integer var3, @Query(value="includeClosed") boolean var4);

    @GET(value="/app/user_chats/{userChatId}")
    public Observable<UserChatWrapper> getUserChat(@Path(value="userChatId") String var1);

    @GET(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessagesWrapper> getMessages(@Path(value="userChatId") String var1, @Query(value="since") String var2, @Query(value="limit") Integer var3, @Query(value="sortOrder") String var4);

    @POST(value="/app/plugins/{pluginId}/user_chats")
    public Observable<UserChatWrapper> createUserChat(@Header(value="X-Plugin-Key") String var1, @Path(value="pluginId") String var2, @Query(value="welcomedAt") long var3);

    @PUT(value="/app/user_chats/{userChatId}/messages/read")
    public Observable<Void> read(@Path(value="userChatId") String var1, @Query(value="at") Long var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/user_chats/{userChatId}/messages")
    public Observable<MessageWrapper> sendMessage(@Path(value="userChatId") String var1, @Body RequestBody var2);

    @Multipart
    @POST(value="/app/user_chats/{userChatId}/messages/file")
    public Observable<MessageWrapper> uploadFile(@Path(value="userChatId") String var1, @Part MultipartBody.Part var2, @Part(value="requestId") RequestBody var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="app/device_tokens")
    public Observable<Void> sendToken(@Body RequestBody var1);

    @Headers(value={"Content-Type: application/json"})
    @DELETE(value="app/device_tokens/{platform}/{key}")
    public Observable<Void> deleteToken(@Header(value="X-Guest-Jwt") String var1, @Path(value="platform") String var2, @Path(value="key") String var3);

    @Headers(value={"Content-Type: application/json"})
    @PUT(value="app/user_chats/{userChatId}/remove")
    public Observable<Void> removeUserChat(@Path(value="userChatId") String var1);

    @PUT(value="app/user_chats/{userChatId}/close")
    public Observable<MessageWrapper> closeUserChat(@Path(value="userChatId") String var1, @Query(value="formId") @Nullable String var2);

    @FormUrlEncoded
    @PUT(value="app/user_chats/{userChatId}/review")
    public Observable<MessageWrapper> reviewUserChat(@Path(value="userChatId") String var1, @Query(value="formId") @Nullable String var2, @Field(value="review") String var3);

    @GET(value="/countries")
    public Observable<CountryWrapper> getCountries();

    @POST(value="/app/events")
    public Observable<Void> trackEvent(@Body Event var1);

    @GET(value="/app/channels/following_managers")
    public Observable<ManagersWrapper> getFollowingManagers();

    @POST(value="/app/user_chats/{userChatId}/plugins/{pluginId}/profile_bot")
    public Observable<Void> requestProfileBot(@Path(value="userChatId") String var1, @Path(value="pluginId") String var2);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="/app/messages/{messageId}/profile_bot")
    public Observable<MessageWrapper> updateProfileBot(@Path(value="messageId") String var1, @Body RequestBody var2);

    @GET(value="app/messages/{messageId}/translate")
    public Observable<TranslationRepo> getTranslatedMessage(@Path(value="messageId") String var1, @Query(value="language") String var2);
}

